/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.service.host;

import io.sip3.twig.ce.domain.Host;
import io.sip3.twig.ce.repository.HostRepository;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/sip3/twig/ce/service/host/HostService;", "", "()V", "hostRepository", "Lio/sip3/twig/ce/repository/HostRepository;", "create", "Lio/sip3/twig/ce/domain/Host;", "host", "deleteAllByName", "", "name", "", "deleteByName", "findAllByAddr", "", "address", "findByAddr", "findByNameIgnoreCase", "firstByAddr", "firstByNameIgnoreCase", "getByName", "list", "", "saveAll", "hosts", "update", "sip3-twig-ce"})
public class HostService {
    @Autowired
    private HostRepository hostRepository;

    @NotNull
    public Set<Host> list() {
        HostRepository hostRepository = this.hostRepository;
        if (hostRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
            hostRepository = null;
        }
        Iterable iterable = hostRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"hostRepository.findAll()");
        return CollectionsKt.toSet((Iterable)iterable);
    }

    @NotNull
    public Host getByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HostRepository hostRepository = this.hostRepository;
        if (hostRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
            hostRepository = null;
        }
        return hostRepository.getByNameIgnoreCase(name);
    }

    @Nullable
    public Host findByNameIgnoreCase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HostRepository hostRepository = this.hostRepository;
        if (hostRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
            hostRepository = null;
        }
        return hostRepository.findByNameIgnoreCase(name);
    }

    @Nullable
    public Host firstByNameIgnoreCase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HostRepository hostRepository = this.hostRepository;
        if (hostRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
            hostRepository = null;
        }
        return hostRepository.findFirstByNameIgnoreCase(name);
    }

    @Nullable
    public Host findByAddr(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        HostRepository hostRepository = this.hostRepository;
        if (hostRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
            hostRepository = null;
        }
        return hostRepository.findByAddrContains(address);
    }

    @NotNull
    public List<Host> findAllByAddr(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        HostRepository hostRepository = this.hostRepository;
        if (hostRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
            hostRepository = null;
        }
        return hostRepository.findAllByAddrContains(address);
    }

    @Nullable
    public Host firstByAddr(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        HostRepository hostRepository = this.hostRepository;
        if (hostRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
            hostRepository = null;
        }
        return hostRepository.findFirstByAddrContains(address);
    }

    @NotNull
    public Host create(@NotNull Host host2) {
        Host host3;
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        HostRepository hostRepository = this.hostRepository;
        if (hostRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
            hostRepository = null;
        }
        if ((host3 = hostRepository.findByNameIgnoreCase(host2.getName())) != null) {
            Host it = host3;
            boolean bl = false;
            throw new DuplicateKeyException("Host with name \"" + host2.getName() + "\" already exists");
        }
        Iterable $this$forEach$iv = host2.getAddr();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String addr = (String)element$iv;
            boolean bl = false;
            HostRepository hostRepository2 = this.hostRepository;
            if (hostRepository2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
                hostRepository2 = null;
            }
            Host host4 = hostRepository2.findByAddrContains(addr);
            if (host4 == null) continue;
            Host it = host4;
            boolean bl2 = false;
            throw new DuplicateKeyException("Host with addr \"" + addr + "\" already exists: \"" + it.getName() + "\"");
        }
        HostRepository hostRepository3 = this.hostRepository;
        if (hostRepository3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
            hostRepository3 = null;
        }
        Object object = hostRepository3.save((Object)host2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"hostRepository.save(host)");
        return (Host)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Host update(@NotNull Host host2) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Iterable $this$forEach$iv = host2.getAddr();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Host host3;
            Object v0;
            String addr;
            block4: {
                void $this$firstOrNull$iv;
                addr = (String)element$iv;
                boolean bl = false;
                Iterable iterable = this.findAllByAddr(addr);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    Host it = (Host)element$iv2;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)host2.getName()))) continue;
                    v0 = element$iv2;
                    break block4;
                }
                v0 = null;
            }
            if ((host3 = (Host)v0) == null) continue;
            Host it = host3;
            boolean bl = false;
            throw new DuplicateKeyException("Host with addr \"" + addr + "\" already exists: \"" + it.getName() + "\"");
        }
        HostRepository hostRepository = this.hostRepository;
        if (hostRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
            hostRepository = null;
        }
        Host existingHost = hostRepository.getByNameIgnoreCase(host2.getName());
        boolean bl = false;
        existingHost.setAddr(host2.getAddr());
        existingHost.setMapping(host2.getMapping());
        existingHost.setFeature(host2.getFeature());
        HostRepository hostRepository2 = this.hostRepository;
        if (hostRepository2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
            hostRepository2 = null;
        }
        Host host4 = (Host)hostRepository2.save((Object)existingHost);
        Intrinsics.checkNotNullExpressionValue((Object)host4, (String)"hostRepository.getByName\u2026e(existingHost)\n        }");
        return host4;
    }

    public void deleteByName(@NotNull String name) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            HostRepository hostRepository = this.hostRepository;
            if (hostRepository == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
                hostRepository = null;
            }
            Host host2 = hostRepository.findByNameIgnoreCase(name);
            if (host2 == null) break block2;
            Host it = host2;
            boolean bl = false;
            HostRepository hostRepository2 = this.hostRepository;
            if (hostRepository2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
                hostRepository2 = null;
            }
            hostRepository2.delete((Object)it);
        }
    }

    public void deleteAllByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HostRepository hostRepository = this.hostRepository;
        if (hostRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
            hostRepository = null;
        }
        List it = hostRepository.findAllByNameIgnoreCase(name);
        boolean bl = false;
        HostRepository hostRepository2 = this.hostRepository;
        if (hostRepository2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
            hostRepository2 = null;
        }
        hostRepository2.deleteAll((Iterable)it);
    }

    public void saveAll(@NotNull Set<Host> hosts) {
        Intrinsics.checkNotNullParameter(hosts, (String)"hosts");
        Iterable $this$forEach$iv = hosts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Host existingHost;
            Host host2 = (Host)element$iv;
            boolean bl = false;
            HostRepository hostRepository = this.hostRepository;
            if (hostRepository == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
                hostRepository = null;
            }
            if ((existingHost = hostRepository.findByNameIgnoreCase(host2.getName())) == null) {
                HostRepository hostRepository2 = this.hostRepository;
                if (hostRepository2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
                    hostRepository2 = null;
                }
                hostRepository2.save((Object)host2);
                continue;
            }
            existingHost.setAddr(host2.getAddr());
            existingHost.setMapping(host2.getMapping());
            existingHost.setFeature(host2.getFeature());
            HostRepository hostRepository3 = this.hostRepository;
            if (hostRepository3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hostRepository");
                hostRepository3 = null;
            }
            hostRepository3.save((Object)existingHost);
        }
    }
}

