/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.util;

import java.net.InetAddress;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lio/sip3/twig/ce/util/IpAddressUtil;", "", "()V", "isValid", "", "ip", "", "validateIpAndRange", "delimiter", "intRange", "Lkotlin/ranges/IntRange;", "validateIpString", "sip3-twig-ce"})
public final class IpAddressUtil {
    @NotNull
    public static final IpAddressUtil INSTANCE = new IpAddressUtil();

    private IpAddressUtil() {
    }

    public final boolean isValid(@NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        return StringsKt.contains$default((CharSequence)ip, (CharSequence)"/", (boolean)false, (int)2, null) ? this.validateIpAndRange(ip, "/", new IntRange(0, 32)) : (StringsKt.contains$default((CharSequence)ip, (CharSequence)":", (boolean)false, (int)2, null) ? this.validateIpAndRange(ip, ":", new IntRange(1, 65535)) : this.validateIpString(ip));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validateIpAndRange(String ip, String delimiter, IntRange intRange) {
        String[] stringArray = new String[]{delimiter};
        List splitted = StringsKt.split$default((CharSequence)ip, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (!this.validateIpString((String)splitted.get(0))) return false;
        stringArray = intRange;
        Integer n = StringsKt.toIntOrNull((String)((String)splitted.get(1)));
        if (n == null) return false;
        if (!stringArray.contains(n.intValue())) return false;
        return true;
    }

    private final boolean validateIpString(String ip) {
        boolean bl;
        try {
            bl = InetAddress.getByName(ip) != null;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }
}

