/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.service.participant;

import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.parser.StringMsgParser;
import io.sip3.twig.ce.domain.Event;
import io.sip3.twig.ce.domain.Host;
import io.sip3.twig.ce.domain.Participant;
import io.sip3.twig.ce.service.host.HostService;
import io.sip3.twig.ce.service.participant.ParticipantService;
import io.sip3.twig.ce.util.MediaDescriptionFieldUtilKt;
import io.sip3.twig.ce.util.SipMessageUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.restcomm.media.sdp.SessionDescription;
import org.restcomm.media.sdp.fields.MediaDescriptionField;
import org.restcomm.media.sdp.ice.attributes.CandidateAttribute;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u0016H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0004@\u0004X\u0085.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lio/sip3/twig/ce/service/participant/ParticipantService;", "", "()V", "hostService", "Lio/sip3/twig/ce/service/host/HostService;", "getHostService", "()Lio/sip3/twig/ce/service/host/HostService;", "setHostService", "(Lio/sip3/twig/ce/service/host/HostService;)V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "collectMediaAddresses", "", "", "sipMessage", "Lgov/nist/javax/sip/message/SIPMessage;", "collectParticipants", "", "Lio/sip3/twig/ce/domain/Participant;", "events", "Lio/sip3/twig/ce/domain/Event;", "parseSIPMessage", "event", "sip3-twig-ce"})
public class ParticipantService {
    @NotNull
    private final KLogger logger;
    @Autowired
    protected HostService hostService;

    public ParticipantService() {
        StringMsgParser.setComputeContentLengthFromMessage((boolean)true);
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    @NotNull
    protected final KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    protected final HostService getHostService() {
        HostService hostService = this.hostService;
        if (hostService != null) {
            return hostService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"hostService");
        return null;
    }

    protected final void setHostService(@NotNull HostService hostService) {
        Intrinsics.checkNotNullParameter((Object)hostService, (String)"<set-?>");
        this.hostService = hostService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Participant> collectParticipants(@NotNull List<Event> events) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] event;
        Set $i$f$any2;
        boolean bl;
        boolean isFirst;
        block14: {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            isFirst = false;
            isFirst = true;
            Iterable $this$any$iv = events;
            boolean $i$f$any2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Event it = (Event)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)"RTPR")) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        boolean hasMedia = bl;
        Set $this$collectParticipants_u24lambda_u242 = $i$f$any2 = (Set)new LinkedHashSet();
        boolean bl3 = false;
        Object $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            event = (Object[])element$iv;
            boolean bl4 = false;
            $this$collectParticipants_u24lambda_u242.add(event.getSrc());
            $this$collectParticipants_u24lambda_u242.add(event.getDst());
        }
        Set namesFromEvents = $i$f$any2;
        Set names = new LinkedHashSet();
        Iterable $this$forEach$iv2 = events;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            SIPMessage sipMessage;
            Event event2 = (Event)element$iv;
            boolean bl5 = false;
            event = new String[]{event2.getSrc(), event2.getDst()};
            List eventHosts = CollectionsKt.listOf((Object[])event);
            if (hasMedia && Intrinsics.areEqual((Object)event2.getType(), (Object)"SIP") && (sipMessage = this.parseSIPMessage(event2)) != null && SipMessageUtilKt.hasSdp((SIPMessage)sipMessage)) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable iterable = this.collectMediaAddresses(sipMessage);
                boolean $i$f$map = false;
                void var16_27 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl6 = false;
                    Object object = this.getHostService().firstByAddr((String)it);
                    if (object == null || (object = object.getName()) == null) {
                        object = it;
                    }
                    collection.add(object);
                }
                List mediaAddresses = (List)destination$iv$iv;
                if (Intrinsics.areEqual((Object)SipMessageUtilKt.method((SIPMessage)sipMessage), (Object)"INVITE") && isFirst) {
                    isFirst = false;
                    names.addAll(mediaAddresses);
                } else {
                    names.addAll(eventHosts);
                    names.addAll(mediaAddresses);
                }
            }
            names.addAll(eventHosts);
        }
        $this$forEach$iv2 = CollectionsKt.intersect((Iterable)names, (Iterable)namesFromEvents);
        boolean $i$f$map = false;
        $this$forEach$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Host host2;
            void name;
            String eventHosts = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl7 = false;
            try {
                Host host3 = this.getHostService().findByNameIgnoreCase((String)name);
                if (host3 == null) {
                    host3 = new Document();
                }
                host2 = host3;
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, (Function0)new /* Unavailable Anonymous Inner Class!! */);
                host2 = new Document();
            }
            Host host4 = host2;
            collection.add(new Participant((String)name, "host", (Object)host4));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public SIPMessage parseSIPMessage(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getDetails();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.Document");
        String rawData = ((Document)object).getString((Object)"raw_data");
        try {
            StringMsgParser stringMsgParser = new StringMsgParser();
            Intrinsics.checkNotNullExpressionValue((Object)rawData, (String)"rawData");
            byte[] byArray = rawData.getBytes(Charsets.ISO_8859_1);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return stringMsgParser.parseSIPMessage(byArray, true, false, null);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, (Function0)parseSIPMessage.1.INSTANCE);
            return null;
        }
    }

    @NotNull
    public Set<String> collectMediaAddresses(@NotNull SIPMessage sipMessage) {
        Set set;
        block5: {
            CandidateAttribute[] candidateAttributeArray;
            SessionDescription sessionDescription2;
            SessionDescription sessionDescription3;
            Intrinsics.checkNotNullParameter((Object)sipMessage, (String)"sipMessage");
            try {
                sessionDescription3 = SipMessageUtilKt.sessionDescription((SIPMessage)sipMessage);
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, (Function0)collectMediaAddresses.sessionDescription.1.INSTANCE);
                sessionDescription3 = null;
            }
            SessionDescription sessionDescription4 = sessionDescription2 = sessionDescription3;
            Object object = sessionDescription4 != null ? sessionDescription4.getMediaDescription("audio") : null;
            if (object == null) {
                return SetsKt.emptySet();
            }
            MediaDescriptionField mediaDescription = object;
            Set $this$collectMediaAddresses_u24lambda_u249 = set = (Set)new LinkedHashSet();
            boolean bl = false;
            $this$collectMediaAddresses_u24lambda_u249.add(MediaDescriptionFieldUtilKt.address((MediaDescriptionField)mediaDescription));
            if (candidateAttributeArray == null) break block5;
            candidateAttributeArray = mediaDescription.getCandidates();
            Intrinsics.checkNotNullExpressionValue((Object)candidateAttributeArray, (String)"candidates");
            CandidateAttribute[] $this$forEach$iv = candidateAttributeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String it;
                String string;
                CandidateAttribute element$iv;
                CandidateAttribute candidate = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                String string2 = string = candidate.getAddress();
                if (string2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"address");
                    it = string;
                    boolean bl3 = false;
                    $this$collectMediaAddresses_u24lambda_u249.add(it);
                }
                String string3 = string = candidate.getRelatedAddress();
                if (string3 == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"relatedAddress");
                it = string;
                boolean bl4 = false;
                $this$collectMediaAddresses_u24lambda_u249.add(it);
            }
        }
        return set;
    }
}

