/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.service.media.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lio/sip3/twig/ce/service/media/util/LegSessionUtil;", "", "()V", "generateLegId", "", "report", "Lorg/bson/Document;", "generatePartyId", "source", "sip3-twig-ce"})
public final class LegSessionUtil {
    @NotNull
    public static final LegSessionUtil INSTANCE = new LegSessionUtil();

    private LegSessionUtil() {
    }

    @NotNull
    public final String generateLegId(@NotNull Document report) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        String callId = report.getString((Object)"call_id");
        String srcAddr = report.getString((Object)"src_addr");
        String dstAddr = report.getString((Object)"dst_addr");
        Intrinsics.checkNotNullExpressionValue((Object)dstAddr, (String)"dstAddr");
        return srcAddr.compareTo(dstAddr) > 0 ? callId + ":" + srcAddr + ":" + dstAddr : callId + ":" + dstAddr + ":" + srcAddr;
    }

    @NotNull
    public final String generatePartyId(@NotNull Document report, @NotNull String source) {
        String string;
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String srcAddr = report.getString((Object)"src_addr");
        Integer srcPort = report.getInteger((Object)"src_port");
        String dstAddr = report.getString((Object)"dst_addr");
        Integer dstPort = report.getInteger((Object)"dst_port");
        String string2 = source;
        if (Intrinsics.areEqual((Object)string2, (Object)"rtcp")) {
            string = dstAddr + ":" + dstPort + ":" + srcAddr + ":" + srcPort;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"rtp")) {
            string = srcAddr + ":" + srcPort + ":" + dstAddr + ":" + dstPort;
        } else {
            throw new IllegalArgumentException("Unsupported RTP Report source: '" + source + "'");
        }
        return string;
    }
}

