/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.service;

import io.sip3.twig.ce.mongo.MongoClient;
import io.sip3.twig.ce.service.CacheService;
import io.sip3.twig.ce.service.attribute.AttributeService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="cache", name={"refresh_delay"})
@EnableScheduling
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/sip3/twig/ce/service/CacheService;", "", "()V", "attributeService", "Lio/sip3/twig/ce/service/attribute/AttributeService;", "logger", "Lmu/KLogger;", "mongoClient", "Lio/sip3/twig/ce/mongo/MongoClient;", "refreshCache", "", "sip3-twig-ce"})
public final class CacheService {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @Autowired
    private MongoClient mongoClient;
    @Autowired
    private AttributeService attributeService;

    @Scheduled(fixedRateString="${cache.refresh_rate}", timeUnit=TimeUnit.MILLISECONDS)
    public final void refreshCache() {
        try {
            MongoClient mongoClient = this.mongoClient;
            if (mongoClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mongoClient");
                mongoClient = null;
            }
            mongoClient.listCollectionNames();
            AttributeService attributeService = this.attributeService;
            if (attributeService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attributeService");
                attributeService = null;
            }
            attributeService.list();
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, (Function0)refreshCache.1.INSTANCE);
        }
    }
}

