/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.twig.ce.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.sip3.twig.ce.domain.AddressMapping;
import io.sip3.twig.ce.domain.Host;
import io.sip3.twig.ce.service.host.HostService;
import io.sip3.twig.ce.util.IpAddressUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Tag(name="Hosts API", description="Host Controller")
@RestController
@RequestMapping(value={"/hosts"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\bH\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u00020\b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000f\u001a\u00020\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0007J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0007J\u0012\u0010\u0014\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\bH\u0007J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bH\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/sip3/twig/ce/controller/HostController;", "", "()V", "hostService", "Lio/sip3/twig/ce/service/host/HostService;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "create", "Lio/sip3/twig/ce/domain/Host;", "host", "deleteByName", "", "name", "", "getByName", "import", "file", "Lorg/springframework/web/multipart/MultipartFile;", "list", "", "update", "validate", "sip3-twig-ce"})
public final class HostController {
    @Autowired
    private HostService hostService;
    @Autowired
    private ObjectMapper mapper;

    @Operation(summary="List hosts")
    @ApiResponses(value={@ApiResponse(description="Returns hosts", responseCode="200"), @ApiResponse(description="InternalServerError", responseCode="500"), @ApiResponse(description="ConnectionTimeoutError", responseCode="504")})
    @GetMapping(produces={"application/json"})
    @NotNull
    public final Set<Host> list() {
        HostService hostService = this.hostService;
        if (hostService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostService");
            hostService = null;
        }
        return hostService.list();
    }

    @Operation(summary="Get host by name")
    @ApiResponses(value={@ApiResponse(description="Returns host", responseCode="200"), @ApiResponse(description="Host not found", responseCode="404"), @ApiResponse(description="InternalServerError", responseCode="500"), @ApiResponse(description="ConnectionTimeoutError", responseCode="504")})
    @GetMapping(value={"/{name}"}, produces={"application/json"})
    @NotNull
    public final Host getByName(@Valid @jakarta.validation.constraints.NotNull @PathVariable(value="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HostService hostService = this.hostService;
        if (hostService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostService");
            hostService = null;
        }
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return hostService.getByName(string);
    }

    @Operation(summary="Create host")
    @ApiResponses(value={@ApiResponse(description="Returns host", responseCode="200"), @ApiResponse(description="Bad request", responseCode="400"), @ApiResponse(description="Duplicate host", responseCode="409"), @ApiResponse(description="InternalServerError", responseCode="500"), @ApiResponse(description="ConnectionTimeoutError", responseCode="504")})
    @PostMapping(consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public final Host create(@Valid @RequestBody @NotNull Host host2) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        this.validate(host2);
        HostService hostService = this.hostService;
        if (hostService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostService");
            hostService = null;
        }
        return hostService.create(host2);
    }

    @Operation(summary="Update host")
    @ApiResponses(value={@ApiResponse(description="Returns host", responseCode="200"), @ApiResponse(description="Bad request", responseCode="400"), @ApiResponse(description="Host not found", responseCode="404"), @ApiResponse(description="InternalServerError", responseCode="500"), @ApiResponse(description="ConnectionTimeoutError", responseCode="504")})
    @PutMapping(consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public final Host update(@Valid @RequestBody @NotNull Host host2) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        this.validate(host2);
        HostService hostService = this.hostService;
        if (hostService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostService");
            hostService = null;
        }
        return hostService.update(host2);
    }

    @Operation(summary="Delete host by name")
    @ApiResponses(value={@ApiResponse(description="Host deleted successfully", responseCode="204"), @ApiResponse(description="Bad request", responseCode="400"), @ApiResponse(description="InternalServerError", responseCode="500"), @ApiResponse(description="ConnectionTimeoutError", responseCode="504")})
    @DeleteMapping(value={"/{name}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public final void deleteByName(@Valid @PathVariable(value="name") @jakarta.validation.constraints.NotNull @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HostService hostService = this.hostService;
        if (hostService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostService");
            hostService = null;
        }
        hostService.deleteByName(name);
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Import hosts from JSON file")
    @ApiResponses(value={@ApiResponse(description="Hosts added and updated successfully", responseCode="204"), @ApiResponse(description="Bad request", responseCode="400"), @ApiResponse(description="InternalServerError", responseCode="500"), @ApiResponse(description="ConnectionTimeoutError", responseCode="504")})
    @PostMapping(value={"/import"}, consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public final void import(@RequestPart(value="file", required=true) @Valid @jakarta.validation.constraints.NotNull @NotNull MultipartFile file) {
        boolean hasDuplicates;
        void $this$mapTo$iv$iv;
        void $this$readValue$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ObjectMapper objectMapper = this.mapper;
        if (objectMapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mapper");
            objectMapper = null;
        }
        ObjectMapper objectMapper2 = objectMapper;
        InputStream inputStream = file.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"file.inputStream");
        InputStream src$iv = inputStream;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef22 = false;
        Set hosts = (Set)$this$readValue$iv.readValue(src$iv, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Iterable $this$map$iv = hosts;
        boolean $i$f$map = false;
        Iterable $i$f$jacksonTypeRef22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Host host2 = (Host)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            collection.add(string);
        }
        boolean bl = hasDuplicates = CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).size() != hosts.size();
        if (hasDuplicates) {
            throw new IllegalArgumentException("name");
        }
        Iterable $this$forEach$iv = hosts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Host it = (Host)element$iv;
            boolean bl2 = false;
            this.validate(it);
        }
        HostService hostService = this.hostService;
        if (hostService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostService");
            hostService = null;
        }
        hostService.saveAll(hosts);
    }

    private final void validate(Host host2) {
        if (host2.getAddr().isEmpty()) {
            throw new IllegalArgumentException("addr");
        }
        Iterable $this$forEach$iv = host2.getAddr();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String address = (String)element$iv;
            boolean bl = false;
            if (IpAddressUtil.INSTANCE.isValid(address)) continue;
            throw new IllegalArgumentException("addr");
        }
        $this$forEach$iv = host2.getMapping();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AddressMapping mapping = (AddressMapping)element$iv;
            boolean bl = false;
            if (!IpAddressUtil.INSTANCE.isValid(mapping.getSource())) {
                throw new IllegalArgumentException("mapping.source");
            }
            if (IpAddressUtil.INSTANCE.isValid(mapping.getTarget())) continue;
            throw new IllegalArgumentException("mapping.target");
        }
    }
}

