/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.fields.parser;

import java.util.regex.Pattern;
import org.restcomm.media.sdp.SdpException;
import org.restcomm.media.sdp.SdpParser;
import org.restcomm.media.sdp.fields.MediaDescriptionField;

public class MediaDescriptionFieldParser
implements SdpParser<MediaDescriptionField> {
    private static final String REGEX = "^m=[a-zA-Z]+\\s\\d+\\s[a-zA-Z/]+(\\s\\w+)*$";
    private static final Pattern PATTERN = Pattern.compile("^m=[a-zA-Z]+\\s\\d+\\s[a-zA-Z/]+(\\s\\w+)*$");

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public MediaDescriptionField parse(String sdp) throws SdpException {
        try {
            String[] values2 = sdp.trim().substring(2).split(" ");
            int index = 0;
            int maxIndex = values2.length - 1;
            String media = values2[index++];
            int port = Integer.parseInt(values2[index++]);
            String protocol = values2[index++];
            String[] formats = null;
            if (maxIndex - index >= 0) {
                int numFormats = maxIndex - index + 1;
                formats = new String[numFormats];
                for (int i2 = 0; i2 < numFormats; ++i2) {
                    formats[i2] = values2[i2 + index];
                }
            }
            MediaDescriptionField md = new MediaDescriptionField();
            md.setMedia(media);
            md.setPort(port);
            md.setProtocol(protocol);
            md.setPayloadTypes(formats);
            return md;
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(MediaDescriptionField field, String sdp) throws SdpException {
        try {
            String[] values2 = sdp.trim().substring(2).split(" ");
            int index = 0;
            int maxIndex = values2.length - 1;
            String media = values2[index++];
            int port = Integer.parseInt(values2[index++]);
            String protocol = values2[index++];
            String[] payloadTypes = null;
            if (maxIndex - index >= 0) {
                int numFormats = maxIndex - index + 1;
                payloadTypes = new String[numFormats];
                for (int i2 = 0; i2 < numFormats; ++i2) {
                    payloadTypes[i2] = values2[i2 + index];
                }
            }
            field.setMedia(media);
            field.setPort(port);
            field.setProtocol(protocol);
            field.setPayloadTypes(payloadTypes);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }
}

