/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Map;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.PropertySource;

public class EnvironmentPropertySource
implements PropertySource {
    @Override
    public int getPriority() {
        return -100;
    }

    @Override
    public void forEach(BiConsumer<String, String> action) {
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("LOG4J_")) continue;
            action.accept(key.substring(6), entry.getValue());
        }
    }

    @Override
    public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
        StringBuilder sb = new StringBuilder("LOG4J");
        for (CharSequence charSequence : tokens) {
            sb.append('_');
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                sb.append(Character.toUpperCase(charSequence.charAt(i2)));
            }
        }
        return sb.toString();
    }
}

