/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.micrometer.MatchType;
import io.vertx.micrometer.MetricsDomain;

@DataObject
public class Match {
    public static final MatchType DEFAULT_TYPE = MatchType.EQUALS;
    private MetricsDomain domain;
    private String label;
    private String value;
    private MatchType type;
    private String alias;

    public Match() {
        this.type = DEFAULT_TYPE;
    }

    public Match(Match other) {
        this.domain = other.domain;
        this.label = other.label;
        this.value = other.value;
        this.type = other.type;
    }

    public Match(JsonObject json) {
        if (json.containsKey("domain")) {
            this.domain = MetricsDomain.valueOf(json.getString("domain"));
        }
        this.label = json.getString("label");
        this.value = json.getString("value");
        this.type = MatchType.valueOf(json.getString("type", DEFAULT_TYPE.name()));
        this.alias = json.getString("alias");
    }

    public MetricsDomain getDomain() {
        return this.domain;
    }

    public Match setDomain(MetricsDomain domain) {
        this.domain = domain;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public Match setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public Match setValue(String value) {
        this.value = value;
        return this;
    }

    public MatchType getType() {
        return this.type;
    }

    public Match setType(MatchType type) {
        this.type = type;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public Match setAlias(String alias) {
        this.alias = alias;
        return this;
    }
}

