/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.codec.json;

import io.vertx.core.json.JsonObject;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public abstract class AbstractJsonCodec<O, A>
implements Codec<O> {
    @Override
    public O decode(BsonReader reader, DecoderContext decoderContext) {
        return this.readDocument(reader, decoderContext);
    }

    @Override
    public void encode(BsonWriter writer, O value, EncoderContext encoderContext) {
        this.writeDocument(writer, null, value, encoderContext);
    }

    protected Object readValue(BsonReader reader, DecoderContext ctx) {
        BsonType type = reader.getCurrentBsonType();
        switch (type) {
            case NULL: {
                return this.readNull(reader, ctx);
            }
            case ARRAY: {
                return this.readArray(reader, ctx);
            }
            case BINARY: {
                return this.readBinary(reader, ctx);
            }
            case BOOLEAN: {
                return this.readBoolean(reader, ctx);
            }
            case DATE_TIME: {
                return this.readDateTime(reader, ctx);
            }
            case DB_POINTER: {
                return this.readDbPointer(reader, ctx);
            }
            case DOCUMENT: {
                return this.readDocument(reader, ctx);
            }
            case DOUBLE: {
                return this.readDouble(reader, ctx);
            }
            case INT32: {
                return this.readInt32(reader, ctx);
            }
            case INT64: {
                return this.readInt64(reader, ctx);
            }
            case MAX_KEY: {
                return this.readMaxKey(reader, ctx);
            }
            case MIN_KEY: {
                return this.readMinKey(reader, ctx);
            }
            case JAVASCRIPT: {
                return this.readJavaScript(reader, ctx);
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return this.readJavaScriptWithScope(reader, ctx);
            }
            case OBJECT_ID: {
                return this.readObjectId(reader, ctx);
            }
            case REGULAR_EXPRESSION: {
                return this.readRegularExpression(reader, ctx);
            }
            case STRING: {
                return this.readString(reader, ctx);
            }
            case SYMBOL: {
                return this.readSymbol(reader, ctx);
            }
            case TIMESTAMP: {
                return this.readTimeStamp(reader, ctx);
            }
            case UNDEFINED: {
                return this.readUndefined(reader, ctx);
            }
            case DECIMAL128: {
                return this.readNumberDecimal(reader, ctx);
            }
        }
        throw new IllegalStateException("Unknown bson type " + (Object)((Object)type));
    }

    protected void writeValue(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        BsonType type = this.getBsonType(value);
        if (type == null) {
            throw new IllegalStateException("Unknown BsonType for '" + value + "'");
        }
        switch (type) {
            case NULL: {
                this.writeNull(writer, name, value, ctx);
                break;
            }
            case ARRAY: {
                this.writeArray(writer, name, value, ctx);
                break;
            }
            case BINARY: {
                this.writeBinary(writer, name, value, ctx);
                break;
            }
            case BOOLEAN: {
                this.writeBoolean(writer, name, value, ctx);
                break;
            }
            case DATE_TIME: {
                this.writeDateTime(writer, name, value, ctx);
                break;
            }
            case DB_POINTER: {
                this.writeDbPointer(writer, name, value, ctx);
                break;
            }
            case DOCUMENT: {
                this.writeDocument(writer, name, value, ctx);
                break;
            }
            case DOUBLE: {
                this.writeDouble(writer, name, value, ctx);
                break;
            }
            case INT32: {
                this.writeInt32(writer, name, value, ctx);
                break;
            }
            case INT64: {
                this.writeInt64(writer, name, value, ctx);
                break;
            }
            case DECIMAL128: {
                this.writeNumberDecimal(writer, name, value, ctx);
                break;
            }
            case MAX_KEY: {
                this.writeMaxKey(writer, name, value, ctx);
                break;
            }
            case MIN_KEY: {
                this.writeMinKey(writer, name, value, ctx);
                break;
            }
            case JAVASCRIPT: {
                this.writeJavaScript(writer, name, value, ctx);
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                this.writeJavaScriptWithScope(writer, name, value, ctx);
                break;
            }
            case OBJECT_ID: {
                this.writeObjectId(writer, name, value, ctx);
                break;
            }
            case REGULAR_EXPRESSION: {
                this.writeRegularExpression(writer, name, value, ctx);
                break;
            }
            case STRING: {
                this.writeString(writer, name, value, ctx);
                break;
            }
            case SYMBOL: {
                this.writeSymbol(writer, name, value, ctx);
                break;
            }
            case TIMESTAMP: {
                this.writeTimeStamp(writer, name, value, ctx);
                break;
            }
            case UNDEFINED: {
                this.writeUndefined(writer, name, value, ctx);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown bson type " + (Object)((Object)type));
            }
        }
    }

    protected BsonType getBsonType(Object value) {
        if (value == null) {
            return BsonType.NULL;
        }
        if (value instanceof Boolean) {
            return BsonType.BOOLEAN;
        }
        if (value instanceof Float) {
            return BsonType.DOUBLE;
        }
        if (value instanceof Double) {
            return BsonType.DOUBLE;
        }
        if (value instanceof BigDecimal) {
            return BsonType.DECIMAL128;
        }
        if (value instanceof Integer) {
            return BsonType.INT32;
        }
        if (value instanceof Long) {
            return BsonType.INT64;
        }
        if (value instanceof String) {
            return BsonType.STRING;
        }
        if (this.isObjectIdInstance(value)) {
            return BsonType.OBJECT_ID;
        }
        if (this.isObjectInstance(value)) {
            return BsonType.DOCUMENT;
        }
        if (this.isArrayInstance(value)) {
            return BsonType.ARRAY;
        }
        return null;
    }

    protected Object readNull(BsonReader reader, DecoderContext ctx) {
        reader.readNull();
        return null;
    }

    protected void writeNull(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        writer.writeNull();
    }

    protected Object readBoolean(BsonReader reader, DecoderContext ctx) {
        return reader.readBoolean();
    }

    protected void writeBoolean(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        writer.writeBoolean((Boolean)value);
    }

    protected Object readDouble(BsonReader reader, DecoderContext ctx) {
        return reader.readDouble();
    }

    protected void writeDouble(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        if (value instanceof Float) {
            writer.writeDouble(((Float)value).doubleValue());
        } else {
            writer.writeDouble((Double)value);
        }
    }

    protected Object readInt32(BsonReader reader, DecoderContext ctx) {
        return reader.readInt32();
    }

    protected void writeInt32(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        writer.writeInt32((Integer)value);
    }

    protected Object readInt64(BsonReader reader, DecoderContext ctx) {
        return reader.readInt64();
    }

    protected void writeInt64(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        if (value instanceof JsonObject) {
            this.writeNumberLong(writer, name, value, ctx);
        } else {
            writer.writeInt64((Long)value);
        }
    }

    protected Object readString(BsonReader reader, DecoderContext ctx) {
        return reader.readString();
    }

    protected void writeString(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        writer.writeString((String)value);
    }

    protected abstract boolean isObjectIdInstance(Object var1);

    protected O readDocument(BsonReader reader, DecoderContext ctx) {
        O object = this.newObject();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String name = reader.readName();
            this.add(object, name, this.readValue(reader, ctx));
        }
        reader.readEndDocument();
        return object;
    }

    protected void writeDocument(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        Object object = value;
        writer.writeStartDocument();
        HashSet skip = new HashSet();
        if (ctx.isEncodingCollectibleDocument()) {
            this.beforeFields(object, (k, v) -> {
                skip.add(k);
                writer.writeName((String)k);
                this.writeValue(writer, (String)k, v, ctx);
            });
        }
        this.forEach(object, (String k, Object v) -> {
            if (!skip.contains(k)) {
                writer.writeName((String)k);
                this.writeValue(writer, (String)k, v, ctx);
            }
        });
        writer.writeEndDocument();
    }

    protected abstract O newObject();

    protected abstract void add(O var1, String var2, Object var3);

    protected abstract boolean isObjectInstance(Object var1);

    protected void beforeFields(O object, BiConsumer<String, Object> objectConsumer) {
    }

    protected abstract void forEach(O var1, BiConsumer<String, Object> var2);

    protected A readArray(BsonReader reader, DecoderContext ctx) {
        A array = this.newArray();
        reader.readStartArray();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            this.add(array, this.readValue(reader, ctx));
        }
        reader.readEndArray();
        return array;
    }

    protected void writeArray(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        Object array = value;
        writer.writeStartArray();
        this.forEach(array, (Object o) -> this.writeValue(writer, null, o, ctx));
        writer.writeEndArray();
    }

    protected abstract A newArray();

    protected abstract void add(A var1, Object var2);

    protected abstract boolean isArrayInstance(Object var1);

    protected abstract void forEach(A var1, Consumer<Object> var2);

    protected Object readBinary(BsonReader reader, DecoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void writeBinary(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected Object readDateTime(BsonReader reader, DecoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void writeDateTime(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected Object readDbPointer(BsonReader reader, DecoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void writeDbPointer(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected Object readMaxKey(BsonReader reader, DecoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void writeMaxKey(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected Object readMinKey(BsonReader reader, DecoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void writeMinKey(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected Object readJavaScript(BsonReader reader, DecoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void writeJavaScript(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected Object readJavaScriptWithScope(BsonReader reader, DecoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void writeJavaScriptWithScope(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected Object readObjectId(BsonReader reader, DecoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void writeObjectId(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected Object readRegularExpression(BsonReader reader, DecoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void writeRegularExpression(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected Object readSymbol(BsonReader reader, DecoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void writeSymbol(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected Object readTimeStamp(BsonReader reader, DecoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void writeTimeStamp(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected Object readUndefined(BsonReader reader, DecoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void writeUndefined(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void writeNumberLong(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void writeNumberDecimal(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected Object readNumberDecimal(BsonReader reader, DecoderContext ctx) {
        throw new UnsupportedOperationException();
    }
}

