/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventExecutor;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.WorkerTask;
import io.vertx.core.impl.WorkerTaskQueue;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;

public class WorkerExecutor
implements EventExecutor {
    private final WorkerPool workerPool;
    private final WorkerTaskQueue orderedTasks;
    private final ThreadLocal<Boolean> inThread = new ThreadLocal();

    public static WorkerExecutor unwrapWorkerExecutor() {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof VertxThread) {
            VertxThread vertxThread = (VertxThread)thread2;
            String msg = vertxThread.isWorker() ? "Cannot be called on a Vert.x worker thread" : "Cannot be called on a Vert.x event-loop thread";
            throw new IllegalStateException(msg);
        }
        ContextInternal ctx = VertxImpl.currentContext(thread2);
        if (ctx != null && ctx.inThread()) {
            return (WorkerExecutor)ctx.executor();
        }
        return null;
    }

    public WorkerExecutor(WorkerPool workerPool, WorkerTaskQueue orderedTasks) {
        this.workerPool = workerPool;
        this.orderedTasks = orderedTasks;
    }

    @Override
    public boolean inThread() {
        return this.inThread.get() == Boolean.TRUE;
    }

    @Override
    public void execute(final Runnable command2) {
        PoolMetrics metrics = this.workerPool.metrics();
        Object queueMetric = metrics != null ? metrics.submitted() : null;
        WorkerTask task = new WorkerTask(metrics, queueMetric){

            @Override
            protected void execute() {
                WorkerExecutor.this.inThread.set(true);
                try {
                    command2.run();
                }
                finally {
                    WorkerExecutor.this.inThread.remove();
                }
            }
        };
        this.orderedTasks.execute(task, this.workerPool.executor());
    }

    WorkerTaskQueue taskQueue() {
        return this.orderedTasks;
    }

    public CountDownLatch suspend(Consumer<Continuation> resumeAcceptor) {
        return this.orderedTasks.suspend(resumeAcceptor);
    }

    public static interface Continuation {
        public void resume(Runnable var1);

        default public void resume() {
            this.resume(() -> {});
        }
    }
}

