/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.spi.utils;

import io.vertx.config.spi.ConfigProcessor;
import io.vertx.config.spi.utils.Processors;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.launcher.commands.FileSelector;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;

public class FileSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSet.class);
    private final String pattern;
    private final ConfigProcessor processor;
    private final File root;
    private final Vertx vertx;
    private final Boolean rawData;
    private final Boolean hierarchical;

    public FileSet(Vertx vertx, File root, JsonObject set) {
        this.vertx = vertx;
        this.root = root;
        this.pattern = set.getString("pattern");
        if (this.pattern == null) {
            throw new IllegalArgumentException("Each file set needs to contain a `pattern`");
        }
        this.rawData = set.getBoolean("raw-data", false);
        this.hierarchical = set.getBoolean("hierarchical", false);
        String format = set.getString("format", "json");
        this.processor = Processors.get(format);
        if (this.processor == null) {
            throw new IllegalArgumentException("Unknown configuration format `" + format + "`, supported types are " + Processors.getSupportedFormats());
        }
    }

    private boolean matches(String path) {
        return FileSelector.match(this.pattern, path, false);
    }

    public void buildConfiguration(List<File> files, Handler<AsyncResult<JsonObject>> handler) {
        ArrayList<Future> futures = new ArrayList<Future>();
        files.stream().map(file -> {
            String relative = null;
            if (file.getAbsolutePath().startsWith(this.root.getAbsolutePath())) {
                relative = file.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1);
            }
            if (relative == null) {
                LOGGER.warn("The file `" + file.getAbsolutePath() + "` is not in '" + this.root.getAbsolutePath() + "'");
            }
            return relative;
        }).filter(Objects::nonNull).filter(this::matches).map(s -> new File(this.root, (String)s)).forEach(file -> {
            Promise promise = Promise.promise();
            futures.add(promise.future());
            try {
                this.vertx.fileSystem().readFile(file.getAbsolutePath(), buffer -> {
                    if (buffer.failed()) {
                        promise.fail(buffer.cause());
                    } else {
                        this.processor.process(this.vertx, new JsonObject().put("raw-data", this.rawData).put("hierarchical", this.hierarchical), (Buffer)buffer.result()).onComplete(promise);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                promise.fail(e);
            }
        });
        CompositeFuture.all(futures).onComplete(ar -> {
            if (ar.failed()) {
                handler.handle(Future.failedFuture(ar.cause()));
            } else {
                JsonObject result2 = new JsonObject();
                futures.stream().map(future -> (JsonObject)future.result()).forEach(config2 -> result2.mergeIn((JsonObject)config2, true));
                handler.handle(Future.succeededFuture(result2));
            }
        });
    }

    public static List<File> traverse(File root) {
        ArrayList<File> files = new ArrayList<File>();
        if (!root.isDirectory()) {
            return files;
        }
        File[] children2 = root.listFiles();
        if (children2 == null) {
            return files;
        }
        for (File file : children2) {
            if (file.isDirectory()) {
                files.addAll(FileSet.traverse(file));
                continue;
            }
            files.add(file);
        }
        return files;
    }
}

