/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.rtpr;

import io.sip3.commons.domain.media.MediaControl;
import io.sip3.commons.domain.media.SdpSession;
import io.sip3.commons.domain.payload.RtpReportPayload;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.domain.Packet;
import io.sip3.salto.ce.rtpr.RtprStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u0005\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 Z2\u00020\u0001:\u0001ZB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020YR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001eR\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b/\u00101R\u001a\u00102\u001a\u000203X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001e\u00108\u001a\u0004\u0018\u000109X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010>\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001a\u0010?\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u00101\"\u0004\bA\u0010BR\u0011\u0010C\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u000bR\u001c\u0010E\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010,\"\u0004\bG\u0010.R\u001a\u0010H\u001a\u00020IX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u001a\u0010N\u001a\u00020\"X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010$\"\u0004\bP\u0010&R\u001a\u0010Q\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010\u001e\"\u0004\bS\u0010 \u00a8\u0006["}, d2={"Lio/sip3/salto/ce/rtpr/RtprSession;", "", "()V", "attributes", "", "", "getAttributes", "()Ljava/util/Map;", "badReportCount", "", "getBadReportCount", "()I", "badReportFraction", "", "getBadReportFraction", "()D", "callId", "getCallId", "()Ljava/lang/String;", "callee", "getCallee", "caller", "getCaller", "codecs", "", "getCodecs", "()Ljava/util/Set;", "createdAt", "", "getCreatedAt", "()J", "setCreatedAt", "(J)V", "dstAddr", "Lio/sip3/salto/ce/domain/Address;", "getDstAddr", "()Lio/sip3/salto/ce/domain/Address;", "setDstAddr", "(Lio/sip3/salto/ce/domain/Address;)V", "duration", "getDuration", "forward", "Lio/sip3/salto/ce/rtpr/RtprStream;", "getForward", "()Lio/sip3/salto/ce/rtpr/RtprStream;", "setForward", "(Lio/sip3/salto/ce/rtpr/RtprStream;)V", "isOneWay", "", "()Z", "mediaControl", "Lio/sip3/commons/domain/media/MediaControl;", "getMediaControl", "()Lio/sip3/commons/domain/media/MediaControl;", "setMediaControl", "(Lio/sip3/commons/domain/media/MediaControl;)V", "rFactorThreshold", "", "getRFactorThreshold", "()Ljava/lang/Float;", "setRFactorThreshold", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "recorded", "getRecorded", "setRecorded", "(Z)V", "reportCount", "getReportCount", "reverse", "getReverse", "setReverse", "source", "", "getSource", "()B", "setSource", "(B)V", "srcAddr", "getSrcAddr", "setSrcAddr", "terminatedAt", "getTerminatedAt", "setTerminatedAt", "add", "", "packet", "Lio/sip3/salto/ce/domain/Packet;", "payload", "Lio/sip3/commons/domain/payload/RtpReportPayload;", "Companion", "sip3-salto-ce"})
public final class RtprSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long createdAt = Long.MAX_VALUE;
    private long terminatedAt;
    public Address srcAddr;
    public Address dstAddr;
    private byte source;
    public MediaControl mediaControl;
    private boolean recorded;
    @Nullable
    private Float rFactorThreshold;
    @Nullable
    private RtprStream forward;
    @Nullable
    private RtprStream reverse;

    public final long getCreatedAt() {
        return this.createdAt;
    }

    public final void setCreatedAt(long l) {
        this.createdAt = l;
    }

    public final long getTerminatedAt() {
        return this.terminatedAt;
    }

    public final void setTerminatedAt(long l) {
        this.terminatedAt = l;
    }

    @NotNull
    public final Address getSrcAddr() {
        Address address = this.srcAddr;
        if (address != null) {
            return address;
        }
        Intrinsics.throwUninitializedPropertyAccessException("srcAddr");
        return null;
    }

    public final void setSrcAddr(@NotNull Address address) {
        Intrinsics.checkNotNullParameter(address, "<set-?>");
        this.srcAddr = address;
    }

    @NotNull
    public final Address getDstAddr() {
        Address address = this.dstAddr;
        if (address != null) {
            return address;
        }
        Intrinsics.throwUninitializedPropertyAccessException("dstAddr");
        return null;
    }

    public final void setDstAddr(@NotNull Address address) {
        Intrinsics.checkNotNullParameter(address, "<set-?>");
        this.dstAddr = address;
    }

    public final byte getSource() {
        return this.source;
    }

    public final void setSource(byte by) {
        this.source = by;
    }

    @NotNull
    public final MediaControl getMediaControl() {
        MediaControl mediaControl = this.mediaControl;
        if (mediaControl != null) {
            return mediaControl;
        }
        Intrinsics.throwUninitializedPropertyAccessException("mediaControl");
        return null;
    }

    public final void setMediaControl(@NotNull MediaControl mediaControl) {
        Intrinsics.checkNotNullParameter(mediaControl, "<set-?>");
        this.mediaControl = mediaControl;
    }

    public final boolean getRecorded() {
        return this.recorded;
    }

    public final void setRecorded(boolean bl) {
        this.recorded = bl;
    }

    @Nullable
    public final Float getRFactorThreshold() {
        return this.rFactorThreshold;
    }

    public final void setRFactorThreshold(@Nullable Float f) {
        this.rFactorThreshold = f;
    }

    @Nullable
    public final RtprStream getForward() {
        return this.forward;
    }

    public final void setForward(@Nullable RtprStream rtprStream) {
        this.forward = rtprStream;
    }

    @Nullable
    public final RtprStream getReverse() {
        return this.reverse;
    }

    public final void setReverse(@Nullable RtprStream rtprStream) {
        this.reverse = rtprStream;
    }

    @NotNull
    public final String getCallId() {
        return this.getMediaControl().getCallId();
    }

    @NotNull
    public final String getCaller() {
        return this.getMediaControl().getCaller();
    }

    @NotNull
    public final String getCallee() {
        return this.getMediaControl().getCallee();
    }

    public final int getReportCount() {
        RtprStream rtprStream = this.forward;
        RtprStream rtprStream2 = this.reverse;
        return (rtprStream != null ? rtprStream.getReportCount() : 0) + (rtprStream2 != null ? rtprStream2.getReportCount() : 0);
    }

    public final int getBadReportCount() {
        RtprStream rtprStream = this.forward;
        RtprStream rtprStream2 = this.reverse;
        return (rtprStream != null ? rtprStream.getBadReportCount() : 0) + (rtprStream2 != null ? rtprStream2.getBadReportCount() : 0);
    }

    public final double getBadReportFraction() {
        return this.getReportCount() > 0 ? (double)this.getBadReportCount() / (double)this.getReportCount() : 0.0;
    }

    @NotNull
    public final Set<String> getCodecs() {
        Set set;
        block1: {
            Object object;
            Object it;
            Set $this$_get_codecs__u24lambda_u242 = set = (Set)new LinkedHashSet();
            boolean bl = false;
            Object object2 = this.forward;
            if (object2 != null && (object2 = ((RtprStream)object2).getCodecNames()) != null) {
                it = object2;
                boolean bl2 = false;
                $this$_get_codecs__u24lambda_u242.addAll((Collection)it);
            }
            if ((object = this.reverse) == null || (object = ((RtprStream)object).getCodecNames()) == null) break block1;
            it = object;
            boolean bl3 = false;
            $this$_get_codecs__u24lambda_u242.addAll((Collection)it);
        }
        return set;
    }

    public final boolean isOneWay() {
        return this.source == 0 && this.forward != null ^ this.reverse != null;
    }

    public final long getDuration() {
        return this.terminatedAt - this.createdAt;
    }

    @NotNull
    public final Map<String, Object> getAttributes() {
        Map map2;
        block3: {
            Object object;
            Object value;
            String name;
            Map.Entry entry;
            Map.Entry element$iv;
            Iterator iterator2;
            boolean $i$f$forEach;
            Object $this$forEach$iv;
            Map $this$_get_attributes__u24lambda_u245 = map2 = (Map)new LinkedHashMap();
            boolean bl = false;
            Object object2 = this.forward;
            if (object2 != null && (object2 = ((RtprStream)object2).getAttributes()) != null) {
                $this$forEach$iv = object2;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    name = (String)entry.getKey();
                    value = entry.getValue();
                    $this$_get_attributes__u24lambda_u245.put(name, value);
                }
            }
            if ((object = this.reverse) == null || (object = ((RtprStream)object).getAttributes()) == null) break block3;
            $this$forEach$iv = object;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry = element$iv = iterator2.next();
                boolean bl3 = false;
                name = (String)entry.getKey();
                value = entry.getValue();
                $this$_get_attributes__u24lambda_u245.put(name, value);
            }
        }
        return map2;
    }

    public final void add(@NotNull Packet packet, @NotNull RtpReportPayload payload) {
        boolean isForward;
        Intrinsics.checkNotNullParameter(packet, "packet");
        Intrinsics.checkNotNullParameter(payload, "payload");
        boolean bl = this.source == 0 ? packet.getSrcAddr().equals(this.getSrcAddr()) || packet.getDstAddr().equals(this.getDstAddr()) : (isForward = packet.getSrcAddr().equals(this.getDstAddr()) || packet.getDstAddr().equals(this.getSrcAddr()));
        if (isForward) {
            if (this.forward == null) {
                this.forward = new RtprStream(this.rFactorThreshold);
            }
            RtprStream rtprStream = this.forward;
            Intrinsics.checkNotNull(rtprStream);
            rtprStream.add(packet, payload);
            RtprStream rtprStream2 = this.forward;
            Intrinsics.checkNotNull(rtprStream2);
            this.createdAt = Math.min(this.createdAt, rtprStream2.getCreatedAt());
            RtprStream rtprStream3 = this.forward;
            Intrinsics.checkNotNull(rtprStream3);
            this.terminatedAt = Math.max(this.terminatedAt, rtprStream3.getTerminatedAt());
        } else {
            if (this.reverse == null) {
                this.reverse = new RtprStream(this.rFactorThreshold);
            }
            RtprStream rtprStream = this.reverse;
            Intrinsics.checkNotNull(rtprStream);
            rtprStream.add(packet, payload);
            RtprStream rtprStream4 = this.reverse;
            Intrinsics.checkNotNull(rtprStream4);
            this.createdAt = Math.min(this.createdAt, rtprStream4.getCreatedAt());
            RtprStream rtprStream5 = this.reverse;
            Intrinsics.checkNotNull(rtprStream5);
            this.terminatedAt = Math.max(this.terminatedAt, rtprStream5.getTerminatedAt());
        }
        this.recorded = payload.getRecorded() || this.recorded;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lio/sip3/salto/ce/rtpr/RtprSession$Companion;", "", "()V", "create", "Lio/sip3/salto/ce/rtpr/RtprSession;", "source", "", "mediaControl", "Lio/sip3/commons/domain/media/MediaControl;", "packet", "Lio/sip3/salto/ce/domain/Packet;", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RtprSession create(byte source2, @NotNull MediaControl mediaControl, @NotNull Packet packet) {
            RtprSession rtprSession;
            Intrinsics.checkNotNullParameter(mediaControl, "mediaControl");
            Intrinsics.checkNotNullParameter(packet, "packet");
            RtprSession $this$create_u24lambda_u240 = rtprSession = new RtprSession();
            boolean bl = false;
            $this$create_u24lambda_u240.setSource(source2);
            $this$create_u24lambda_u240.setMediaControl(mediaControl);
            SdpSession sdpSession = mediaControl.getSdpSession();
            byte by = source2;
            if (by == 0) {
                if (Intrinsics.areEqual(sdpSession.getSrc().getRtpId(), packet.getSrcAddr().sdpSessionId()) || Intrinsics.areEqual(sdpSession.getDst().getRtpId(), packet.getDstAddr().sdpSessionId())) {
                    $this$create_u24lambda_u240.setSrcAddr(packet.getSrcAddr());
                    $this$create_u24lambda_u240.setDstAddr(packet.getDstAddr());
                } else {
                    $this$create_u24lambda_u240.setSrcAddr(packet.getDstAddr());
                    $this$create_u24lambda_u240.setDstAddr(packet.getSrcAddr());
                }
            } else if (by == 1) {
                if (Intrinsics.areEqual(sdpSession.getSrc().getRtcpId(), packet.getDstAddr().sdpSessionId()) || Intrinsics.areEqual(sdpSession.getDst().getRtcpId(), packet.getSrcAddr().sdpSessionId())) {
                    $this$create_u24lambda_u240.setSrcAddr(packet.getDstAddr());
                    $this$create_u24lambda_u240.setDstAddr(packet.getSrcAddr());
                } else {
                    $this$create_u24lambda_u240.setSrcAddr(packet.getSrcAddr());
                    $this$create_u24lambda_u240.setDstAddr(packet.getDstAddr());
                }
            }
            return rtprSession;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

