/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.influx;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.StringUtils;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.InvalidReason;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.influx.InfluxApiVersion;
import io.micrometer.influx.InfluxConsistency;

public interface InfluxConfig
extends StepRegistryConfig {
    public static final InfluxConfig DEFAULT = k -> null;

    @Override
    default public String prefix() {
        return "influx";
    }

    default public String db() {
        return PropertyValidator.getString(this, "db").orElse("mydb");
    }

    default public InfluxConsistency consistency() {
        return PropertyValidator.getEnum(this, InfluxConsistency.class, "consistency").orElse(InfluxConsistency.ONE);
    }

    @Nullable
    default public String userName() {
        return PropertyValidator.getSecret(this, "userName").orElse(null);
    }

    @Nullable
    default public String password() {
        return PropertyValidator.getSecret(this, "password").orElse(null);
    }

    @Nullable
    default public String retentionPolicy() {
        return PropertyValidator.getString(this, "retentionPolicy").orElse(null);
    }

    @Nullable
    default public String retentionDuration() {
        return PropertyValidator.getString(this, "retentionDuration").orElse(null);
    }

    @Nullable
    default public Integer retentionReplicationFactor() {
        return PropertyValidator.getInteger(this, "retentionReplicationFactor").orElse(null);
    }

    @Nullable
    default public String retentionShardDuration() {
        return PropertyValidator.getString(this, "retentionShardDuration").orElse(null);
    }

    default public String uri() {
        return PropertyValidator.getUrlString(this, "uri").orElse("http://localhost:8086");
    }

    default public boolean compressed() {
        return PropertyValidator.getBoolean(this, "compressed").orElse(true);
    }

    default public boolean autoCreateDb() {
        return PropertyValidator.getBoolean(this, "autoCreateDb").orElse(true);
    }

    default public InfluxApiVersion apiVersion() {
        return PropertyValidator.getEnum(this, InfluxApiVersion.class, "apiVersion").orElseGet(() -> {
            if (StringUtils.isNotBlank(this.org())) {
                return InfluxApiVersion.V2;
            }
            return InfluxApiVersion.V1;
        });
    }

    @Nullable
    default public String org() {
        return PropertyValidator.getString(this, "org").orElse(null);
    }

    default public String bucket() {
        return (String)PropertyValidator.getString(this, "bucket").flatMap((bucket, valid) -> {
            if (StringUtils.isNotBlank(bucket)) {
                return Validated.valid(valid.getProperty(), bucket);
            }
            String db = this.db();
            if (StringUtils.isNotBlank(db)) {
                return Validated.valid(valid.getProperty(), db);
            }
            return Validated.invalid(valid.getProperty(), bucket, "db or bucket should be specified", InvalidReason.MISSING);
        }).get();
    }

    @Nullable
    default public String token() {
        return PropertyValidator.getString(this, "token").orElse(null);
    }

    @Override
    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll(this, c -> StepRegistryConfig.validate(c), MeterRegistryConfigValidator.checkRequired("db", InfluxConfig::db), MeterRegistryConfigValidator.checkRequired("bucket", InfluxConfig::bucket), MeterRegistryConfigValidator.checkRequired("consistency", InfluxConfig::consistency), MeterRegistryConfigValidator.checkRequired("apiVersion", InfluxConfig::apiVersion).andThen(v -> v.invalidateWhen(a -> a == InfluxApiVersion.V2 && StringUtils.isBlank(this.org()), "requires 'org' is also configured", InvalidReason.MISSING)).andThen(v -> v.invalidateWhen(a -> a == InfluxApiVersion.V2 && StringUtils.isBlank(this.token()), "requires 'token' is also configured", InvalidReason.MISSING)), MeterRegistryConfigValidator.checkRequired("uri", InfluxConfig::uri));
    }
}

