/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.elastic;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.InvalidReason;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.time.format.DateTimeFormatter;

public interface ElasticConfig
extends StepRegistryConfig {
    public static final ElasticConfig DEFAULT = k -> null;

    @Override
    @Nullable
    public String get(String var1);

    @Override
    default public String prefix() {
        return "elastic";
    }

    default public String host() {
        return PropertyValidator.getUrlString(this, "host").orElse("http://localhost:9200");
    }

    default public String index() {
        return PropertyValidator.getString(this, "index").orElse("micrometer-metrics");
    }

    default public String indexDateFormat() {
        return PropertyValidator.getString(this, "indexDateFormat").invalidateWhen(format -> {
            if (format == null) {
                return false;
            }
            try {
                DateTimeFormatter.ofPattern(format);
                return false;
            }
            catch (IllegalArgumentException ignored) {
                return true;
            }
        }, "invalid date format", InvalidReason.MALFORMED).orElse("yyyy-MM");
    }

    default public String timestampFieldName() {
        return PropertyValidator.getString(this, "timestampFieldName").orElse("@timestamp");
    }

    default public boolean autoCreateIndex() {
        return PropertyValidator.getBoolean(this, "autoCreateIndex").orElse(true);
    }

    @Nullable
    default public String userName() {
        return PropertyValidator.getSecret(this, "userName").orElse(null);
    }

    @Nullable
    default public String password() {
        return PropertyValidator.getSecret(this, "password").orElse(null);
    }

    @Nullable
    default public String pipeline() {
        return PropertyValidator.getString(this, "pipeline").orElse(null);
    }

    default public String indexDateSeparator() {
        return PropertyValidator.getString(this, "indexDateSeparator").orElse("-");
    }

    @Nullable
    default public String apiKeyCredentials() {
        return PropertyValidator.getSecret(this, "apiKeyCredentials").orElse(null);
    }

    @Deprecated
    default public String documentType() {
        return PropertyValidator.getString(this, "documentType").orElse("doc");
    }

    @Override
    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll(this, c -> StepRegistryConfig.validate(c), MeterRegistryConfigValidator.checkRequired("host", ElasticConfig::host), MeterRegistryConfigValidator.checkRequired("index", ElasticConfig::index), MeterRegistryConfigValidator.checkRequired("timestampFieldName", ElasticConfig::timestampFieldName), MeterRegistryConfigValidator.checkRequired("indexDateFormat", ElasticConfig::indexDateFormat).andThen(v -> v.invalidateWhen(format -> {
            if (format == null) {
                return true;
            }
            try {
                DateTimeFormatter.ofPattern(format);
                return false;
            }
            catch (IllegalArgumentException ignored) {
                return true;
            }
        }, "invalid date format", InvalidReason.MALFORMED)), MeterRegistryConfigValidator.checkRequired("indexDateSeparator", ElasticConfig::indexDateSeparator), MeterRegistryConfigValidator.checkRequired("documentType", ElasticConfig::documentType));
    }
}

