/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.DialogTimeoutEvent;
import gov.nist.javax.sip.EventWrapper;
import gov.nist.javax.sip.SipListenerExt;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.util.EventObject;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipListener;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;

public class EventScanner
implements Runnable {
    private static StackLogger logger = CommonLogger.getLogger(EventScanner.class);
    private boolean isStopped;
    private BlockingQueue<EventWrapper> pendingEvents;
    private AtomicInteger refCount = new AtomicInteger(0);
    private SipStackImpl sipStack;

    public void incrementRefcount() {
        this.refCount.incrementAndGet();
    }

    public EventScanner(SipStackImpl sipStackImpl) {
        this.pendingEvents = new LinkedBlockingQueue<EventWrapper>();
        Thread myThread = new Thread(this);
        myThread.setDaemon(false);
        this.sipStack = sipStackImpl;
        myThread.setName("EventScannerThread");
        myThread.start();
    }

    public void addEvent(EventWrapper eventWrapper) {
        boolean added;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("addEvent " + eventWrapper);
        }
        if (!(added = this.pendingEvents.offer(eventWrapper))) {
            logger.logWarning("reached queue capacity limit couldn't addEvent " + eventWrapper);
        }
    }

    public void stop() {
        if (this.refCount.get() == 0) {
            this.isStopped = true;
        }
    }

    public void forceStop() {
        this.isStopped = true;
        this.refCount.set(0);
    }

    public void deliverEvent(EventWrapper eventWrapper) {
        EventObject sipEvent = eventWrapper.sipEvent;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sipEvent = " + sipEvent + "source = " + sipEvent.getSource());
        }
        SipListener sipListener = null;
        sipListener = !(sipEvent instanceof IOExceptionEvent) ? ((SipProviderImpl)sipEvent.getSource()).getSipListener() : this.sipStack.getSipListener();
        if (sipEvent instanceof RequestEvent) {
            this.deliverRequestEvent((RequestEvent)sipEvent, eventWrapper, sipListener);
        } else if (sipEvent instanceof ResponseEvent) {
            this.deliverResponseEvent((ResponseEvent)sipEvent, eventWrapper, sipListener);
        } else if (sipEvent instanceof TimeoutEvent) {
            this.deliverTimeoutEvent((TimeoutEvent)sipEvent, eventWrapper, sipListener);
        } else if (sipEvent instanceof DialogTimeoutEvent) {
            this.deliverDialogTimeoutEvent((DialogTimeoutEvent)sipEvent, eventWrapper, sipListener);
        } else if (sipEvent instanceof IOExceptionEvent) {
            this.deliverIOExceptionEvent((IOExceptionEvent)sipEvent, eventWrapper, sipListener);
        } else if (sipEvent instanceof TransactionTerminatedEvent) {
            this.deliverTransactionTerminatedEvent((TransactionTerminatedEvent)sipEvent, eventWrapper, sipListener);
        } else if (sipEvent instanceof DialogTerminatedEvent) {
            this.deliverDialogTerminatedEvent((DialogTerminatedEvent)sipEvent, eventWrapper, sipListener);
        } else {
            logger.logFatalError("bad event" + sipEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deliverRequestEvent(RequestEvent sipEvent, EventWrapper eventWrapper, SipListener sipListener) {
        try {
            SIPRequest sipRequest;
            block20: {
                block19: {
                    SIPServerTransaction tx;
                    sipRequest = (SIPRequest)sipEvent.getRequest();
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("deliverEvent : " + sipRequest.getFirstLine() + " transaction " + eventWrapper.transaction + " sipEvent.serverTx = " + sipEvent.getServerTransaction());
                    }
                    if ((tx = (SIPServerTransaction)this.sipStack.findTransaction(sipRequest, true)) == null || tx.passToListener()) break block19;
                    if (sipRequest.getMethod().equals("ACK") && tx.isInviteTransaction() && (tx.getLastResponseStatusCode() / 100 == 2 || this.sipStack.isNon2XXAckPassedToListener())) {
                        if (!this.sipStack.isNon2XXAckPassedToListener() && logger.isLoggingEnabled(32)) {
                            logger.logDebug("Detected broken client sending ACK with same branch! Passing...");
                        }
                        break block20;
                    } else {
                        if (!logger.isLoggingEnabled(32)) return;
                        logger.logDebug("transaction already exists! " + tx);
                        return;
                    }
                }
                if (this.sipStack.findPendingTransaction(sipRequest.getTransactionId()) != null) {
                    if (!logger.isLoggingEnabled(32)) return;
                    logger.logDebug("transaction already exists!!");
                    return;
                }
                SIPServerTransaction st = (SIPServerTransaction)eventWrapper.transaction;
                this.sipStack.putPendingTransaction(st);
            }
            sipRequest.setTransaction(eventWrapper.transaction);
            try {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Calling listener " + sipRequest.getFirstLine());
                    logger.logDebug("Calling listener " + eventWrapper.transaction);
                }
                if (sipListener != null) {
                    sipListener.processRequest(sipEvent);
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Done processing Message " + sipRequest.getFirstLine());
                }
                if (eventWrapper.transaction == null) return;
                SIPDialog dialog = (SIPDialog)eventWrapper.transaction.getDialog();
                if (dialog == null) return;
                dialog.requestConsumed();
                return;
            }
            catch (Exception ex) {
                logger.logException(ex);
                return;
            }
        }
        finally {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Done processing Message " + ((SIPRequest)sipEvent.getRequest()).getFirstLine());
            }
            if (eventWrapper.transaction != null && ((SIPServerTransaction)eventWrapper.transaction).passToListener()) {
                ((SIPServerTransaction)eventWrapper.transaction).releaseSem();
            }
            if (eventWrapper.transaction != null) {
                this.sipStack.removePendingTransaction((SIPServerTransaction)eventWrapper.transaction);
            }
            if (eventWrapper.transaction.getMethod().equals("ACK")) {
                eventWrapper.transaction.setState(5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverResponseEvent(ResponseEvent responseEvent, EventWrapper eventWrapper, SipListener sipListener) {
        try {
            SIPResponse sipResponse = (SIPResponse)responseEvent.getResponse();
            SIPDialog sipDialog = (SIPDialog)responseEvent.getDialog();
            try {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Calling listener " + sipListener + " for " + sipResponse.getFirstLine());
                }
                if (sipListener != null) {
                    SIPTransaction tx = eventWrapper.transaction;
                    if (tx != null) {
                        tx.setPassToListener();
                    }
                    sipListener.processResponse(responseEvent);
                }
                if (!(sipDialog == null || sipDialog.getState() != null && sipDialog.getState().equals(DialogState.TERMINATED) || sipResponse.getStatusCode() != 481 && sipResponse.getStatusCode() != 408)) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Removing dialog on 408 or 481 response");
                    }
                    sipDialog.doDeferredDelete();
                }
                if (sipResponse.getCSeq().getMethod().equals("INVITE") && sipDialog != null && sipResponse.getStatusCode() == 200) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Warning! unacknowledged dialog. " + sipDialog.getState());
                    }
                    sipDialog.doDeferredDeleteIfNoAckSent(sipResponse.getCSeq().getSeqNumber());
                }
            }
            catch (Exception ex) {
                logger.logException(ex);
            }
            SIPClientTransaction ct = (SIPClientTransaction)eventWrapper.transaction;
            if (ct != null && 3 == ct.getInternalState() && !ct.getMethod().equals("INVITE")) {
                ct.clearState();
            }
        }
        finally {
            if (eventWrapper.transaction != null && eventWrapper.transaction.passToListener()) {
                eventWrapper.transaction.releaseSem();
            }
        }
    }

    private void deliverTimeoutEvent(TimeoutEvent timeoutEvent, EventWrapper eventWrapper, SipListener sipListener) {
        try {
            if (sipListener != null) {
                sipListener.processTimeout(timeoutEvent);
            }
        }
        catch (Exception ex) {
            logger.logException(ex);
        }
    }

    private void deliverDialogTimeoutEvent(DialogTimeoutEvent dialogTimeoutEvent, EventWrapper eventWrapper, SipListener sipListener) {
        try {
            if (sipListener != null && sipListener instanceof SipListenerExt) {
                ((SipListenerExt)sipListener).processDialogTimeout(dialogTimeoutEvent);
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("DialogTimeoutEvent not delivered");
            }
        }
        catch (Exception ex) {
            logger.logException(ex);
        }
    }

    private void deliverIOExceptionEvent(IOExceptionEvent sipEvent, EventWrapper eventWrapper, SipListener sipListener) {
        try {
            if (sipListener != null) {
                sipListener.processIOException(sipEvent);
            }
        }
        catch (Exception ex) {
            logger.logException(ex);
        }
    }

    private void deliverTransactionTerminatedEvent(TransactionTerminatedEvent sipEvent, EventWrapper eventWrapper, SipListener sipListener) {
        try {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("About to deliver transactionTerminatedEvent");
                logger.logDebug("tx = " + sipEvent.getClientTransaction());
                logger.logDebug("tx = " + sipEvent.getServerTransaction());
            }
            if (sipListener != null) {
                sipListener.processTransactionTerminated(sipEvent);
            }
        }
        catch (AbstractMethodError ame) {
            if (logger.isLoggingEnabled()) {
                logger.logWarning("Unable to call sipListener.processTransactionTerminated");
            }
        }
        catch (Exception ex) {
            logger.logException(ex);
        }
    }

    private void deliverDialogTerminatedEvent(DialogTerminatedEvent sipEvent, EventWrapper eventWrapper, SipListener sipListener) {
        try {
            if (sipListener != null) {
                sipListener.processDialogTerminated(sipEvent);
            }
        }
        catch (AbstractMethodError ame) {
            if (logger.isLoggingEnabled()) {
                logger.logWarning("Unable to call sipListener.processDialogTerminated");
            }
        }
        catch (Exception ex) {
            logger.logException(ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        threadHandle = null;
        if (this.sipStack.getThreadAuditor() != null) {
            threadHandle = this.sipStack.getThreadAuditor().addCurrentThread();
        }
        while (true) lbl-1000:
        // 4 sources

        {
            eventWrapper = null;
            if (this.isStopped) {
                if (EventScanner.logger.isLoggingEnabled(32)) {
                    EventScanner.logger.logDebug("Stopped event scanner!!");
                }
                return;
            }
            if (threadHandle != null) {
                threadHandle.ping();
            }
            try {
                eventWrapper = this.pendingEvents.take();
                this.deliverEvent(eventWrapper);
            }
            catch (InterruptedException ex) {
                if (EventScanner.logger.isLoggingEnabled(4)) {
                    EventScanner.logger.logError("Interrupted!", ex);
                }
                if (EventScanner.logger.isLoggingEnabled(32) && !this.isStopped) {
                    EventScanner.logger.logFatalError("Event scanner exited abnormally");
                }
                return;
            }
            catch (Exception e) {
                if (!EventScanner.logger.isLoggingEnabled()) ** GOTO lbl-1000
                EventScanner.logger.logError("Unexpected exception caught while delivering event -- carrying on bravely", e);
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            if (EventScanner.logger.isLoggingEnabled(32) && !this.isStopped) {
                EventScanner.logger.logFatalError("Event scanner exited abnormally");
            }
        }
    }
}

