/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.fields;

import gov.nist.core.GenericObject;
import gov.nist.core.GenericObjectList;
import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sdp.fields.SDPFieldNames;
import java.lang.reflect.Field;

public abstract class SDPObject
extends GenericObject
implements SDPFieldNames {
    protected static final String SDPFIELDS_PACKAGE = "gov.nist.javax.sdp.fields";
    protected static final String CORE_PACKAGE = "gov.nist.core";

    @Override
    public abstract String encode();

    @Override
    protected void sprint(String s) {
        super.sprint(s);
    }

    protected void initSprint() {
        this.stringRepresentation = "";
    }

    public String toString() {
        return this.encode();
    }

    protected String getStringRepresentation() {
        return this.stringRepresentation;
    }

    @Override
    public boolean equals(Object that) {
        if (!this.getClass().equals(that.getClass())) {
            return false;
        }
        Class<?> myclass = this.getClass();
        Field[] fields = myclass.getDeclaredFields();
        Class<?> hisclass = that.getClass();
        Field[] hisfields = hisclass.getDeclaredFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            Field f = fields[i2];
            Field g = hisfields[i2];
            int modifier = f.getModifiers();
            if (modifier == 2) continue;
            Class<?> fieldType = f.getType();
            String fieldName = f.getName();
            if (fieldName.compareTo("stringRepresentation") == 0 || fieldName.compareTo("indentation") == 0) continue;
            try {
                if (fieldType.isPrimitive()) {
                    String fname = fieldType.toString();
                    if (!(fname.compareTo("int") == 0 ? f.getInt(this) != g.getInt(that) : (fname.compareTo("short") == 0 ? f.getShort(this) != g.getShort(that) : (fname.compareTo("char") == 0 ? f.getChar(this) != g.getChar(that) : (fname.compareTo("long") == 0 ? f.getLong(this) != g.getLong(that) : (fname.compareTo("boolean") == 0 ? f.getBoolean(this) != g.getBoolean(that) : (fname.compareTo("double") == 0 ? f.getDouble(this) != g.getDouble(that) : fname.compareTo("float") == 0 && f.getFloat(this) != g.getFloat(that)))))))) continue;
                    return false;
                }
                if (g.get(that) == f.get(this)) continue;
                if (f.get(this) == null && g.get(that) != null) {
                    return false;
                }
                if (g.get(that) == null && f.get(that) != null) {
                    return false;
                }
                if (f.get(this).equals(g.get(that))) continue;
                return false;
            }
            catch (IllegalAccessException ex1) {
                InternalErrorHandler.handleException(ex1);
            }
        }
        return true;
    }

    @Override
    public String debugDump() {
        this.stringRepresentation = "";
        Class<?> myclass = this.getClass();
        this.sprint(myclass.getName());
        this.sprint("{");
        Field[] fields = myclass.getDeclaredFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            Field f = fields[i2];
            int modifier = f.getModifiers();
            if (modifier == 2) continue;
            Class<?> fieldType = f.getType();
            String fieldName = f.getName();
            if (fieldName.compareTo("stringRepresentation") == 0 || fieldName.compareTo("indentation") == 0) continue;
            this.sprint(fieldName + ":");
            try {
                if (fieldType.isPrimitive()) {
                    String fname = fieldType.toString();
                    this.sprint(fname + ":");
                    if (fname.compareTo("int") == 0) {
                        int intfield = f.getInt(this);
                        this.sprint(intfield);
                        continue;
                    }
                    if (fname.compareTo("short") == 0) {
                        short shortField = f.getShort(this);
                        this.sprint(shortField);
                        continue;
                    }
                    if (fname.compareTo("char") == 0) {
                        char charField = f.getChar(this);
                        this.sprint(charField);
                        continue;
                    }
                    if (fname.compareTo("long") == 0) {
                        long longField = f.getLong(this);
                        this.sprint(longField);
                        continue;
                    }
                    if (fname.compareTo("boolean") == 0) {
                        boolean booleanField = f.getBoolean(this);
                        this.sprint(booleanField);
                        continue;
                    }
                    if (fname.compareTo("double") == 0) {
                        double doubleField = f.getDouble(this);
                        this.sprint(doubleField);
                        continue;
                    }
                    if (fname.compareTo("float") != 0) continue;
                    float floatField = f.getFloat(this);
                    this.sprint(floatField);
                    continue;
                }
                if (Class.forName("gov.nist.core.GenericObject").isAssignableFrom(fieldType)) {
                    if (f.get(this) != null) {
                        this.sprint(((GenericObject)f.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (Class.forName("gov.nist.core.GenericObjectList").isAssignableFrom(fieldType)) {
                    if (f.get(this) != null) {
                        this.sprint(((GenericObjectList)f.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (f.get(this) != null) {
                    this.sprint(f.get(this).getClass().getName() + ":");
                } else {
                    this.sprint(fieldType.getName() + ":");
                }
                this.sprint("{");
                if (f.get(this) != null) {
                    this.sprint(f.get(this).toString());
                } else {
                    this.sprint("<null>");
                }
                this.sprint("}");
                continue;
            }
            catch (IllegalAccessException ex1) {
                continue;
            }
            catch (ClassNotFoundException ex) {
                System.out.println("Cound not find " + ex.getMessage());
                ex.printStackTrace();
                System.exit(0);
            }
        }
        this.sprint("}");
        return this.stringRepresentation;
    }

    @Override
    public boolean match(Object other) {
        if (other == null) {
            return true;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        GenericObject that = (GenericObject)other;
        Class<?> myclass = this.getClass();
        Field[] fields = myclass.getDeclaredFields();
        Class<?> hisclass = other.getClass();
        Field[] hisfields = hisclass.getDeclaredFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            Field f = fields[i2];
            Field g = hisfields[i2];
            int modifier = f.getModifiers();
            if (modifier == 2) continue;
            Class<?> fieldType = f.getType();
            String fieldName = f.getName();
            if (fieldName.compareTo("stringRepresentation") == 0 || fieldName.compareTo("indentation") == 0) continue;
            try {
                if (fieldType.isPrimitive()) {
                    String fname = fieldType.toString();
                    if (!(fname.compareTo("int") == 0 ? f.getInt(this) != g.getInt(that) : (fname.compareTo("short") == 0 ? f.getShort(this) != g.getShort(that) : (fname.compareTo("char") == 0 ? f.getChar(this) != g.getChar(that) : (fname.compareTo("long") == 0 ? f.getLong(this) != g.getLong(that) : (fname.compareTo("boolean") == 0 ? f.getBoolean(this) != g.getBoolean(that) : (fname.compareTo("double") == 0 ? f.getDouble(this) != g.getDouble(that) : fname.compareTo("float") == 0 && f.getFloat(this) != g.getFloat(that)))))))) continue;
                    return false;
                }
                Object myObj = f.get(this);
                Object hisObj = g.get(that);
                if (hisObj == myObj) {
                    return true;
                }
                if (hisObj != null && myObj == null) {
                    return false;
                }
                if (hisObj instanceof String && myObj instanceof String) {
                    if (((String)myObj).compareToIgnoreCase((String)hisObj) == 0) continue;
                    return false;
                }
                if (hisObj != null && GenericObject.isMySubclass(myObj.getClass()) && GenericObject.isMySubclass(hisObj.getClass()) && myObj.getClass().equals(hisObj.getClass()) && ((GenericObject)hisObj).getMatcher() != null) {
                    String myObjEncoded = ((GenericObject)myObj).encode();
                    return ((GenericObject)hisObj).getMatcher().match(myObjEncoded);
                }
                if (GenericObject.isMySubclass(myObj.getClass()) && !((GenericObject)myObj).match(hisObj)) {
                    return false;
                }
                if (!GenericObjectList.isMySubclass(myObj.getClass()) || ((GenericObjectList)myObj).match(hisObj)) continue;
                return false;
            }
            catch (IllegalAccessException ex1) {
                InternalErrorHandler.handleException(ex1);
            }
        }
        return true;
    }

    public String dbgPrint(int indent) {
        int save2 = this.indentation;
        this.indentation = indent;
        String retval = this.toString();
        this.indentation = save2;
        return retval;
    }
}

