/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.micrometer.json;

import com.newrelic.telemetry.metrics.Summary;
import com.newrelic.telemetry.micrometer.json.AttributesWriter;
import com.newrelic.telemetry.micrometer.json.JsonUtil;
import java.util.function.Function;

public class SummaryToJson
implements Function<Summary, String> {
    @Override
    public String apply(Summary summary) {
        StringBuilder buff = new StringBuilder();
        JsonUtil.object(buff, () -> {
            JsonUtil.string(buff, "name", summary.getName());
            JsonUtil.string(buff, "type", "summary");
            JsonUtil.object(buff, "value", () -> {
                JsonUtil.number(buff, "count", summary.getCount());
                JsonUtil.number(buff, "sum", summary.getSum());
                JsonUtil.number(buff, "min", summary.getMin());
                JsonUtil.number(buff, "max", summary.getMax(), false);
            });
            JsonUtil.number(buff, "timestamp", summary.getStartTimeMs());
            JsonUtil.number(buff, "interval.ms", summary.getEndTimeMs() - summary.getStartTimeMs(), false);
            AttributesWriter.writeAttributes(buff, summary.getAttributes());
        }, false);
        return buff.toString();
    }
}

