/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.vault;

import com.mongodb.ClientEncryptionSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.WriteConcern;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.Updates;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import com.mongodb.client.model.vault.RewrapManyDataKeyResult;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.internal.crypt.Crypt;
import com.mongodb.reactivestreams.client.internal.crypt.Crypts;
import com.mongodb.reactivestreams.client.vault.ClientEncryption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ClientEncryptionImpl
implements ClientEncryption {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final MongoClient keyVaultClient;
    private final MongoCollection<BsonDocument> collection;

    public ClientEncryptionImpl(ClientEncryptionSettings options) {
        this(MongoClients.create(options.getKeyVaultMongoClientSettings()), options);
    }

    public ClientEncryptionImpl(MongoClient keyVaultClient, ClientEncryptionSettings options) {
        this.keyVaultClient = keyVaultClient;
        this.crypt = Crypts.create(keyVaultClient, options);
        this.options = options;
        MongoNamespace namespace = new MongoNamespace(options.getKeyVaultNamespace());
        this.collection = keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).withReadConcern(ReadConcern.MAJORITY);
    }

    @Override
    public Publisher<BsonBinary> createDataKey(String kmsProvider) {
        return this.createDataKey(kmsProvider, new DataKeyOptions());
    }

    @Override
    public Publisher<BsonBinary> createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions) {
        return this.crypt.createDataKey(kmsProvider, dataKeyOptions).flatMap(dataKeyDocument -> {
            MongoNamespace namespace = new MongoNamespace(this.options.getKeyVaultNamespace());
            return Mono.from(this.keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).insertOne((BsonDocument)dataKeyDocument)).map(i2 -> dataKeyDocument.getBinary("_id"));
        });
    }

    @Override
    public Publisher<BsonBinary> encrypt(BsonValue value, EncryptOptions options) {
        return this.crypt.encryptExplicitly(value, options);
    }

    @Override
    public Publisher<BsonValue> decrypt(BsonBinary value) {
        return this.crypt.decryptExplicitly(value);
    }

    @Override
    public Publisher<DeleteResult> deleteKey(BsonBinary id) {
        return this.collection.deleteOne(Filters.eq("_id", id));
    }

    @Override
    public Publisher<BsonDocument> getKey(BsonBinary id) {
        return this.collection.find(Filters.eq("_id", id)).first();
    }

    @Override
    public FindPublisher<BsonDocument> getKeys() {
        return this.collection.find();
    }

    @Override
    public Publisher<BsonDocument> addKeyAltName(BsonBinary id, String keyAltName) {
        return this.collection.findOneAndUpdate(Filters.eq("_id", id), Updates.addToSet("keyAltNames", keyAltName));
    }

    @Override
    public Publisher<BsonDocument> removeKeyAltName(BsonBinary id, String keyAltName) {
        BsonDocument updateDocument = new BsonDocument().append("$set", new BsonDocument().append("keyAltNames", new BsonDocument().append("$cond", new BsonArray(Arrays.asList(new BsonDocument().append("$eq", new BsonArray(Arrays.asList(new BsonString("$keyAltNames"), new BsonArray(Collections.singletonList(new BsonString(keyAltName)))))), new BsonString("$$REMOVE"), new BsonDocument().append("$filter", new BsonDocument().append("input", new BsonString("$keyAltNames")).append("cond", new BsonDocument().append("$ne", new BsonArray(Arrays.asList(new BsonString("$$this"), new BsonString(keyAltName)))))))))));
        return this.collection.findOneAndUpdate(Filters.eq("_id", id), Collections.singletonList(updateDocument));
    }

    @Override
    public Publisher<BsonDocument> getKeyByAltName(String keyAltName) {
        return this.collection.find(Filters.eq("keyAltNames", keyAltName)).first();
    }

    @Override
    public Publisher<RewrapManyDataKeyResult> rewrapManyDataKey(Bson filter2) {
        return this.rewrapManyDataKey(filter2, new RewrapManyDataKeyOptions());
    }

    @Override
    public Publisher<RewrapManyDataKeyResult> rewrapManyDataKey(Bson filter2, RewrapManyDataKeyOptions options) {
        return Mono.fromRunnable(() -> MongoCryptHelper.validateRewrapManyDataKeyOptions(options)).then(this.crypt.rewrapManyDataKey(filter2.toBsonDocument(BsonDocument.class, this.collection.getCodecRegistry()), options).flatMap(results -> {
            if (results.isEmpty()) {
                return Mono.fromCallable(RewrapManyDataKeyResult::new);
            }
            List updateModels = results.getArray("v", new BsonArray()).stream().map(v -> {
                BsonDocument updateDocument = v.asDocument();
                return new UpdateOneModel(Filters.eq(updateDocument.get("_id")), Updates.combine(Updates.set("masterKey", updateDocument.get("masterKey")), Updates.set("keyMaterial", updateDocument.get("keyMaterial")), Updates.currentDate("updateDate")));
            }).collect(Collectors.toList());
            return Mono.from(this.collection.bulkWrite(updateModels)).map(RewrapManyDataKeyResult::new);
        }));
    }

    @Override
    public void close() {
        this.keyVaultClient.close();
        this.crypt.close();
    }
}

