/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.engine.extension.ExtensionRegistrar;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

final class ExtensionUtils {
    private static final Comparator<Field> orderComparator = Comparator.comparingInt(ExtensionUtils::getOrder);

    private ExtensionUtils() {
    }

    static MutableExtensionRegistry populateNewExtensionRegistryFromExtendWithAnnotation(MutableExtensionRegistry parentRegistry, AnnotatedElement annotatedElement) {
        Preconditions.notNull(parentRegistry, "Parent ExtensionRegistry must not be null");
        Preconditions.notNull(annotatedElement, "AnnotatedElement must not be null");
        return MutableExtensionRegistry.createRegistryFrom(parentRegistry, ExtensionUtils.streamExtensionTypes(annotatedElement));
    }

    static void registerExtensionsFromFields(ExtensionRegistrar registrar, Class<?> clazz, Object instance) {
        Preconditions.notNull(registrar, "ExtensionRegistrar must not be null");
        Preconditions.notNull(clazz, "Class must not be null");
        Predicate<Field> predicate = instance == null ? ReflectionUtils::isStatic : ReflectionUtils::isNotStatic;
        ReflectionUtils.findFields(clazz, predicate, ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).stream().sorted(orderComparator).forEach(field -> {
            List<Class> extensionTypes = ExtensionUtils.streamExtensionTypes(field).collect(Collectors.toList());
            boolean isExtendWithPresent = !extensionTypes.isEmpty();
            boolean isRegisterExtensionPresent = AnnotationUtils.isAnnotated(field, RegisterExtension.class);
            if (isExtendWithPresent) {
                extensionTypes.forEach(registrar::registerExtension);
            }
            if (isRegisterExtensionPresent) {
                ReflectionUtils.tryToReadFieldValue(field, instance).ifSuccess(value -> {
                    Preconditions.condition(value instanceof Extension, () -> String.format("Failed to register extension via @RegisterExtension field [%s]: field value's type [%s] must implement an [%s] API.", field, value != null ? value.getClass().getName() : null, Extension.class.getName()));
                    if (isExtendWithPresent) {
                        Class<?> valueType = value.getClass();
                        extensionTypes.forEach(extensionType -> Preconditions.condition(!extensionType.equals(valueType), () -> String.format("Failed to register extension via field [%s]. The field registers an extension of type [%s] via @RegisterExtension and @ExtendWith, but only one registration of a given extension type is permitted.", field, valueType.getName())));
                    }
                    registrar.registerExtension((Extension)value, field);
                });
            }
        });
    }

    static void registerExtensionsFromConstructorParameters(ExtensionRegistrar registrar, Class<?> clazz) {
        ExtensionUtils.registerExtensionsFromExecutableParameters(registrar, ReflectionUtils.getDeclaredConstructor(clazz));
    }

    static void registerExtensionsFromExecutableParameters(ExtensionRegistrar registrar, Executable executable) {
        Preconditions.notNull(registrar, "ExtensionRegistrar must not be null");
        Preconditions.notNull(executable, "Executable must not be null");
        AtomicInteger index = new AtomicInteger();
        Arrays.stream(executable.getParameters()).map(parameter -> AnnotationUtils.findRepeatableAnnotations(parameter, index.getAndIncrement(), ExtendWith.class)).flatMap(ExtensionUtils::streamExtensionTypes).forEach(registrar::registerExtension);
    }

    private static Stream<Class<? extends Extension>> streamExtensionTypes(AnnotatedElement annotatedElement) {
        return ExtensionUtils.streamExtensionTypes(AnnotationUtils.findRepeatableAnnotations(annotatedElement, ExtendWith.class));
    }

    private static Stream<Class<? extends Extension>> streamExtensionTypes(List<ExtendWith> extendWithAnnotations) {
        return extendWithAnnotations.stream().map(ExtendWith::value).flatMap(Arrays::stream);
    }

    private static int getOrder(Field field) {
        return AnnotationUtils.findAnnotation(field, Order.class).map(Order::value).orElse(0x3FFFFFFF);
    }
}

