/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.lang.reflect.Modifier;
import java.util.StringJoiner;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Parameter;

public class AstToTextHelper {
    public static String getClassText(ClassNode node) {
        if (node == null) {
            return "<unknown>";
        }
        return node.toString(false);
    }

    public static String getParameterText(Parameter node) {
        if (node == null) {
            return "<unknown>";
        }
        String name = node.getName();
        if (name == null) {
            name = "<unknown>";
        }
        String type = AstToTextHelper.getClassText(node.getType());
        String text = type + " " + name;
        if (node.hasInitialExpression()) {
            text = text + " = " + node.getInitialExpression().getText();
        }
        return text;
    }

    public static String getParametersText(Parameter[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return "";
        }
        StringJoiner result2 = new StringJoiner(", ");
        for (Parameter parameter : parameters) {
            result2.add(AstToTextHelper.getParameterText(parameter));
        }
        return result2.toString();
    }

    public static String getThrowsClauseText(ClassNode[] exceptions) {
        if (exceptions == null || exceptions.length == 0) {
            return "";
        }
        StringJoiner result2 = new StringJoiner(", ");
        for (ClassNode exception : exceptions) {
            result2.add(AstToTextHelper.getClassText(exception));
        }
        return " throws " + result2.toString();
    }

    public static String getModifiersText(int modifiers) {
        StringJoiner result2 = new StringJoiner(" ");
        if (Modifier.isPrivate(modifiers)) {
            result2.add("private");
        }
        if (Modifier.isProtected(modifiers)) {
            result2.add("protected");
        }
        if (Modifier.isPublic(modifiers)) {
            result2.add("public");
        }
        if (Modifier.isStatic(modifiers)) {
            result2.add("static");
        }
        if (Modifier.isAbstract(modifiers)) {
            result2.add("abstract");
        }
        if (Modifier.isFinal(modifiers)) {
            result2.add("final");
        }
        if (Modifier.isInterface(modifiers)) {
            result2.add("interface");
        }
        if (Modifier.isNative(modifiers)) {
            result2.add("native");
        }
        if (Modifier.isSynchronized(modifiers)) {
            result2.add("synchronized");
        }
        if (Modifier.isTransient(modifiers)) {
            result2.add("transient");
        }
        if (Modifier.isVolatile(modifiers)) {
            result2.add("volatile");
        }
        return result2.toString();
    }
}

