/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;

@Plugin(name="MapPatternConverter", category="Converter")
@ConverterKeys(value={"K", "map", "MAP"})
public final class MapPatternConverter
extends LogEventPatternConverter {
    private final String key;

    private MapPatternConverter(String[] options) {
        super(options != null && options.length > 0 ? "MAP{" + options[0] + '}' : "MAP", "map");
        this.key = options != null && options.length > 0 ? options[0] : null;
    }

    public static MapPatternConverter newInstance(String[] options) {
        return new MapPatternConverter(options);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        if (!(event.getMessage() instanceof StringMapMessage)) {
            return;
        }
        StringMapMessage msg = (StringMapMessage)event.getMessage();
        IndexedReadOnlyStringMap sortedMap = msg.getIndexedReadOnlyStringMap();
        if (this.key == null) {
            if (sortedMap.isEmpty()) {
                toAppendTo.append("{}");
                return;
            }
            toAppendTo.append("{");
            for (int i2 = 0; i2 < sortedMap.size(); ++i2) {
                if (i2 > 0) {
                    toAppendTo.append(", ");
                }
                toAppendTo.append(sortedMap.getKeyAt(i2)).append('=').append((String)sortedMap.getValueAt(i2));
            }
            toAppendTo.append('}');
        } else {
            String val = (String)sortedMap.getValue(this.key);
            if (val != null) {
                toAppendTo.append(val);
            }
        }
    }
}

