/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.codec.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.codec.BodyCodec;
import io.vertx.ext.web.codec.spi.BodyStream;
import java.util.function.Function;

public class BodyCodecImpl<T>
implements BodyCodec<T> {
    public static final Function<Buffer, Void> VOID_DECODER = buff -> null;
    public static final Function<Buffer, String> UTF8_DECODER = Buffer::toString;
    public static final Function<Buffer, JsonObject> JSON_OBJECT_DECODER = buff -> {
        Object val = Json.decodeValue(buff);
        if (val == null) {
            return null;
        }
        if (val instanceof JsonObject) {
            return (JsonObject)val;
        }
        throw new DecodeException("Invalid Json Object decoded as " + val.getClass().getName());
    };
    public static final Function<Buffer, JsonArray> JSON_ARRAY_DECODER = buff -> {
        Object val = Json.decodeValue(buff);
        if (val == null) {
            return null;
        }
        if (val instanceof JsonArray) {
            return (JsonArray)val;
        }
        throw new DecodeException("Invalid Json Object decoded as " + val.getClass().getName());
    };
    public static final BodyCodec<String> STRING = new BodyCodecImpl<String>(UTF8_DECODER);
    public static final BodyCodec<Void> NONE = new BodyCodecImpl<Void>(VOID_DECODER);
    public static final BodyCodec<Buffer> BUFFER = new BodyCodecImpl<Buffer>(Function.identity());
    public static final BodyCodec<JsonObject> JSON_OBJECT = new BodyCodecImpl<JsonObject>(JSON_OBJECT_DECODER);
    public static final BodyCodec<JsonArray> JSON_ARRAY = new BodyCodecImpl<JsonArray>(JSON_ARRAY_DECODER);
    private final Function<Buffer, T> decoder;

    public static BodyCodecImpl<String> string(String encoding) {
        return new BodyCodecImpl<String>(buff -> buff.toString(encoding));
    }

    public static <T> BodyCodec<T> json(Class<T> type) {
        return new BodyCodecImpl<T>(BodyCodecImpl.jsonDecoder(type));
    }

    public static <T> Function<Buffer, T> jsonDecoder(Class<T> type) {
        return buff -> Json.decodeValue(buff, type);
    }

    public BodyCodecImpl(Function<Buffer, T> decoder) {
        this.decoder = decoder;
    }

    @Override
    public void create(Handler<AsyncResult<BodyStream<T>>> handler) {
        handler.handle(Future.succeededFuture(new BodyStream<T>(){
            final Buffer buffer = Buffer.buffer();
            final Promise<T> state = Promise.promise();

            @Override
            public void handle(Throwable cause) {
                this.state.tryFail(cause);
            }

            @Override
            public Future<T> result() {
                return this.state.future();
            }

            @Override
            public WriteStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
                return this;
            }

            @Override
            public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
                this.buffer.appendBuffer(data);
                handler.handle(Future.succeededFuture());
            }

            @Override
            public Future<Void> write(Buffer data) {
                this.buffer.appendBuffer(data);
                return Future.succeededFuture();
            }

            @Override
            public void end(Handler<AsyncResult<Void>> handler) {
                if (!this.state.future().isComplete()) {
                    Object result2;
                    if (this.buffer.length() > 0) {
                        try {
                            result2 = BodyCodecImpl.this.decoder.apply(this.buffer);
                        }
                        catch (Throwable t) {
                            this.state.fail(t);
                            if (handler != null) {
                                handler.handle(Future.failedFuture(t));
                            }
                            return;
                        }
                    } else {
                        result2 = null;
                    }
                    this.state.complete(result2);
                    if (handler != null) {
                        handler.handle(Future.succeededFuture());
                    }
                }
            }

            @Override
            public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
                return this;
            }

            @Override
            public boolean writeQueueFull() {
                return false;
            }

            @Override
            public WriteStream<Buffer> drainHandler(Handler<Void> handler) {
                return this;
            }
        }));
    }
}

