/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.AggregateOptionsConverter;
import io.vertx.ext.mongo.CollationOptions;
import java.util.Objects;

@DataObject
@JsonGen(publicConverter=false)
public class AggregateOptions {
    public static final int DEFAULT_BATCH_SIZE = 20;
    public static final long DEFAULT_MAX_TIME = 0L;
    public static final long DEFAULT_MAX_AWAIT_TIME = 1000L;
    private int batchSize;
    private long maxTime;
    private long maxAwaitTime;
    private Boolean allowDiskUse;
    private CollationOptions collation;

    public AggregateOptions() {
        this.batchSize = 20;
        this.maxTime = 0L;
        this.maxAwaitTime = 1000L;
        this.collation = null;
    }

    public AggregateOptions(AggregateOptions options) {
        this.batchSize = options.batchSize;
        this.maxTime = options.maxTime;
        this.maxAwaitTime = options.maxAwaitTime;
        this.allowDiskUse = options.allowDiskUse;
        this.collation = options.collation;
    }

    public AggregateOptions(JsonObject options) {
        this();
        AggregateOptionsConverter.fromJson(options, this);
    }

    public CollationOptions getCollation() {
        return this.collation;
    }

    public AggregateOptions setCollation(CollationOptions collation) {
        this.collation = collation;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        AggregateOptionsConverter.toJson(this, json);
        return json;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public AggregateOptions setMaxTime(long maxTime) {
        this.maxTime = maxTime;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public AggregateOptions setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public AggregateOptions setAllowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateOptions that = (AggregateOptions)o;
        return this.batchSize == that.batchSize && this.maxTime == that.maxTime && Objects.equals(this.allowDiskUse, that.allowDiskUse) && Objects.equals(this.collation, that.collation);
    }

    public int hashCode() {
        return Objects.hash(this.batchSize, this.maxTime, this.allowDiskUse, this.collation);
    }

    public String toString() {
        return "AggregateOptions{batchSize=" + this.batchSize + ", maxTime=" + this.maxTime + ", allowDiskUse=" + this.allowDiskUse + ", collation=" + this.collation + '}';
    }
}

