/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher;

import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.InvalidValueException;
import io.vertx.core.cli.MissingOptionException;
import io.vertx.core.cli.MissingValueException;
import io.vertx.core.cli.UsageMessageFormatter;
import io.vertx.core.cli.annotations.CLIConfigurator;
import io.vertx.core.impl.launcher.CommandLineUtils;
import io.vertx.core.impl.launcher.ServiceCommandFactoryLoader;
import io.vertx.core.impl.launcher.commands.RunCommand;
import io.vertx.core.spi.launcher.Command;
import io.vertx.core.spi.launcher.CommandFactory;
import io.vertx.core.spi.launcher.CommandFactoryLookup;
import io.vertx.core.spi.launcher.DefaultCommandFactory;
import io.vertx.core.spi.launcher.ExecutionContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public class VertxCommandLauncher
extends UsageMessageFormatter {
    protected static List<String> PROCESS_ARGS;
    protected final List<CommandFactoryLookup> lookups;
    protected final Map<String, CommandRegistration> commandByName;
    protected Object main;

    public static List<String> getProcessArguments() {
        return PROCESS_ARGS;
    }

    public VertxCommandLauncher() {
        this(Collections.singletonList(new ServiceCommandFactoryLoader()));
    }

    public VertxCommandLauncher(Collection<CommandFactoryLookup> lookups) {
        this.lookups = new ArrayList<CommandFactoryLookup>(lookups);
        this.commandByName = new TreeMap<String, CommandRegistration>();
        this.load();
    }

    protected void load() {
        for (CommandFactoryLookup lookup : this.lookups) {
            Collection<CommandFactory<?>> commands = lookup.lookup();
            commands.forEach(factory2 -> {
                CLI cli = factory2.define();
                CommandRegistration previous = this.commandByName.get(cli.getName());
                if (previous == null) {
                    this.commandByName.put(cli.getName(), new CommandRegistration((CommandFactory)factory2, cli));
                } else if (cli.getPriority() > previous.cli.getPriority()) {
                    this.commandByName.put(cli.getName(), new CommandRegistration((CommandFactory)factory2, cli));
                }
            });
        }
    }

    public VertxCommandLauncher register(CommandFactory factory2) {
        CLI cli = factory2.define();
        this.commandByName.put(cli.getName(), new CommandRegistration(factory2, cli));
        return this;
    }

    @Deprecated
    public VertxCommandLauncher register(Class<? extends Command> clazz) {
        DefaultCommandFactory<? extends Command> factory2 = new DefaultCommandFactory<Command>(clazz);
        CLI cli = factory2.define();
        this.commandByName.put(cli.getName(), new CommandRegistration(factory2, cli));
        return this;
    }

    public VertxCommandLauncher register(Class<? extends Command> clazz, Supplier<? extends Command> supplier) {
        DefaultCommandFactory<? extends Command> factory2 = new DefaultCommandFactory<Command>(clazz, supplier);
        CLI cli = factory2.define();
        this.commandByName.put(cli.getName(), new CommandRegistration(factory2, cli));
        return this;
    }

    public VertxCommandLauncher unregister(String name) {
        this.commandByName.remove(name);
        return this;
    }

    public Collection<String> getCommandNames() {
        return this.commandByName.keySet();
    }

    protected Command getNewCommandInstance(String name, CommandLine commandLine) {
        CommandRegistration registration = this.commandByName.get(name);
        if (registration != null) {
            Object command2 = registration.factory.create(commandLine);
            registration.addCommand((Command)command2);
            return command2;
        }
        return null;
    }

    public Command getExistingCommandInstance(String name) {
        CommandRegistration registration = this.commandByName.get(name);
        if (registration != null) {
            return registration.getCommand();
        }
        return null;
    }

    public void execute(String command2, String ... cla) {
        if (command2 != null && VertxCommandLauncher.isAskingForVersion(command2)) {
            this.execute("version", new String[0]);
            return;
        }
        if (command2 == null || VertxCommandLauncher.isAskingForHelp(command2)) {
            this.printGlobalUsage();
            return;
        }
        CommandRegistration registration = this.commandByName.get(command2);
        if (registration == null) {
            this.printCommandNotFound(command2);
            return;
        }
        CLI cli = registration.cli;
        try {
            if (cla.length >= 1 && VertxCommandLauncher.isAskingForHelp(cla[0])) {
                this.printCommandUsage(cli);
                return;
            }
            CommandLine evaluated = cli.parse(Arrays.asList(cla));
            Command cmd = this.getNewCommandInstance(command2, evaluated);
            ExecutionContext context = new ExecutionContext(cmd, this, evaluated);
            if (this.main != null) {
                context.put("Main", this.main);
                context.put("Main-Class", this.main.getClass().getName());
                context.put("Default-Verticle-Factory", this.getFromManifest("Default-Verticle-Factory"));
            }
            CLIConfigurator.inject(evaluated, cmd);
            cmd.setUp(context);
            cmd.run();
            cmd.tearDown();
        }
        catch (InvalidValueException | MissingOptionException | MissingValueException e) {
            this.printSpecificException(cli, e);
        }
        catch (CLIException e) {
            this.printGenericExecutionError(cli, e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof CLIException) {
                this.printGenericExecutionError(cli, (CLIException)e.getCause());
                return;
            }
            throw e;
        }
    }

    protected void printCommandUsage(CLI cli) {
        StringBuilder builder = new StringBuilder();
        cli.usage(builder, this.getCommandLinePrefix());
        this.getPrintStream().println(builder.toString());
    }

    protected void printGenericExecutionError(CLI cli, CLIException e) {
        this.getPrintStream().println("Error while executing command " + cli.getName() + ": " + e.getMessage() + this.getNewLine());
        if (e.getCause() != null) {
            e.getCause().printStackTrace(this.getPrintStream());
        }
    }

    protected void printSpecificException(CLI cli, Exception e) {
        this.getPrintStream().println(e.getMessage() + this.getNewLine());
        this.printCommandUsage(cli);
    }

    protected void printCommandNotFound(String command2) {
        StringBuilder builder = new StringBuilder();
        this.buildWrapped(builder, 0, "The command '" + command2 + "' is not a valid command." + this.getNewLine() + "See '" + this.getCommandLinePrefix() + " --help'");
        this.getPrintStream().println(builder.toString());
    }

    protected void printGlobalUsage() {
        StringBuilder builder = new StringBuilder();
        this.computeUsage(builder, this.getCommandLinePrefix() + " [COMMAND] [OPTIONS] [arg...]");
        builder.append(this.getNewLine());
        builder.append("Commands:").append(this.getNewLine());
        this.renderCommands(builder, this.commandByName.values().stream().map(r -> r.cli).collect(Collectors.toList()));
        builder.append(this.getNewLine()).append(this.getNewLine());
        this.buildWrapped(builder, 0, "Run '" + this.getCommandLinePrefix() + " COMMAND --help' for more information on a command.");
        this.getPrintStream().println(builder.toString());
    }

    protected String getCommandLinePrefix() {
        String sysProp = System.getProperty("vertx.cli.usage.prefix");
        if (sysProp != null) {
            return sysProp;
        }
        String jar = CommandLineUtils.getJar();
        if (jar != null) {
            return "java -jar " + jar;
        }
        String command2 = CommandLineUtils.getFirstSegmentOfCommand();
        if (command2 != null) {
            return "java " + command2;
        }
        return "vertx";
    }

    protected static boolean isAskingForHelp(String command2) {
        return command2.equalsIgnoreCase("--help") || command2.equalsIgnoreCase("-help") || command2.equalsIgnoreCase("-h") || command2.equalsIgnoreCase("?") || command2.equalsIgnoreCase("/?");
    }

    protected static boolean isAskingForVersion(String command2) {
        return command2.equalsIgnoreCase("-version") || command2.equalsIgnoreCase("--version");
    }

    public void dispatch(String[] args2) {
        this.dispatch(null, args2);
    }

    public void dispatch(Object main, String[] args2) {
        this.main = main == null ? this : main;
        PROCESS_ARGS = Collections.unmodifiableList(Arrays.asList(args2));
        if (args2.length >= 1 && VertxCommandLauncher.isAskingForHelp(args2[0])) {
            this.printGlobalUsage();
            return;
        }
        if (args2.length >= 1 && VertxCommandLauncher.isAskingForVersion(args2[0])) {
            this.execute("version", new String[0]);
            return;
        }
        if (args2.length >= 1 && this.commandByName.get(args2[0]) != null) {
            this.execute(args2[0], Arrays.copyOfRange(args2, 1, args2.length));
            return;
        }
        if (args2.length >= 2 && VertxCommandLauncher.isAskingForHelp(args2[1])) {
            this.execute(args2[0], "--help");
            return;
        }
        String verticle = this.getMainVerticle();
        String command2 = this.getCommandFromManifest();
        if (verticle != null) {
            String[] newArgs = new String[args2.length + 1];
            newArgs[0] = verticle;
            System.arraycopy(args2, 0, newArgs, 1, args2.length);
            this.execute(this.getDefaultCommand(), newArgs);
            return;
        }
        if (command2 != null) {
            this.execute(command2, args2);
            return;
        }
        if (args2.length == 0) {
            this.printGlobalUsage();
        } else if (args2[0].equalsIgnoreCase("-ha")) {
            this.execute("bare", Arrays.copyOfRange(args2, 1, args2.length));
        } else {
            this.printCommandNotFound(args2[0]);
        }
    }

    protected String getDefaultCommand() {
        String fromManifest = this.getCommandFromManifest();
        if (fromManifest == null) {
            return "run";
        }
        return fromManifest;
    }

    protected String getCommandFromManifest() {
        return this.getFromManifest("Main-Command");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFromManifest(String key) {
        try {
            Enumeration<URL> resources = RunCommand.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                InputStream stream2 = resources.nextElement().openStream();
                Throwable throwable = null;
                try {
                    String value;
                    Manifest manifest = new Manifest(stream2);
                    Attributes attributes = manifest.getMainAttributes();
                    String mainClass = attributes.getValue("Main-Class");
                    if (!this.main.getClass().getName().equals(mainClass) || (value = attributes.getValue(key)) == null) continue;
                    String string = value;
                    return string;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream2 == null) continue;
                    if (throwable != null) {
                        try {
                            stream2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream2.close();
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public PrintStream getPrintStream() {
        return System.out;
    }

    protected String getMainVerticle() {
        return this.getFromManifest("Main-Verticle");
    }

    public static void resetProcessArguments() {
        PROCESS_ARGS = null;
    }

    public static class CommandRegistration {
        public final CommandFactory factory;
        public final CLI cli;
        private List<Command> commands = new ArrayList<Command>();

        public CommandRegistration(CommandFactory factory2) {
            this(factory2, factory2.define());
        }

        public CommandRegistration(CommandFactory factory2, CLI cli) {
            this.factory = factory2;
            this.cli = cli;
        }

        public void addCommand(Command command2) {
            this.commands.add(command2);
        }

        public Command getCommand() {
            if (!this.commands.isEmpty()) {
                return this.commands.get(0);
            }
            return null;
        }

        public List<Command> getCommands() {
            return this.commands;
        }
    }
}

