/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.micrometer.shaded.reactor.core.publisher.FluxSink;
import io.micrometer.statsd.StatsdLineBuilder;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class StatsdDistributionSummary
extends AbstractDistributionSummary {
    private final LongAdder count = new LongAdder();
    private final DoubleAdder amount = new DoubleAdder();
    private final TimeWindowMax max;
    private final StatsdLineBuilder lineBuilder;
    private final FluxSink<String> sink;
    private volatile boolean shutdown;

    StatsdDistributionSummary(Meter.Id id, StatsdLineBuilder lineBuilder, FluxSink<String> sink2, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        super(id, clock, distributionStatisticConfig, scale, false);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
        this.lineBuilder = lineBuilder;
        this.sink = sink2;
    }

    @Override
    protected void recordNonNegative(double amount) {
        if (!this.shutdown && amount >= 0.0) {
            this.count.increment();
            this.amount.add(amount);
            this.max.record(amount);
            this.sink.next(this.lineBuilder.histogram(amount));
        }
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalAmount() {
        return this.amount.doubleValue();
    }

    @Override
    public double max() {
        return this.max.poll();
    }

    void shutdown() {
        this.shutdown = true;
    }
}

