/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.DuplicateNameValueList;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.header.ParametersExt;
import gov.nist.javax.sip.header.SIPHeader;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Iterator;
import javax.sip.header.Parameters;

public abstract class ParametersHeader
extends SIPHeader
implements Parameters,
ParametersExt,
Serializable {
    protected NameValueList parameters;
    protected DuplicateNameValueList duplicates;

    protected ParametersHeader() {
        this.parameters = new NameValueList();
        this.duplicates = new DuplicateNameValueList();
    }

    protected ParametersHeader(String hdrName) {
        super(hdrName);
        this.parameters = new NameValueList();
        this.duplicates = new DuplicateNameValueList();
    }

    protected ParametersHeader(String hdrName, boolean sync) {
        super(hdrName);
        this.parameters = new NameValueList(sync);
        this.duplicates = new DuplicateNameValueList();
    }

    @Override
    public String getParameter(String name) {
        return this.parameters.getParameter(name);
    }

    @Override
    public String getParameter(String name, boolean stripQuotes) {
        return this.parameters.getParameter(name, stripQuotes);
    }

    public Object getParameterValue(String name) {
        return this.parameters.getValue(name);
    }

    @Override
    public Iterator<String> getParameterNames() {
        return this.parameters.getNames();
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    @Override
    public void removeParameter(String name) {
        this.parameters.delete(name);
    }

    @Override
    public void setParameter(String name, String value) throws ParseException {
        NameValue nv = this.parameters.getNameValue(name);
        if (nv != null) {
            nv.setValueAsObject(value);
        } else {
            nv = new NameValue(name, value);
            this.parameters.set(nv);
        }
    }

    @Override
    public void setQuotedParameter(String name, String value) throws ParseException {
        NameValue nv = this.parameters.getNameValue(name);
        if (nv != null) {
            nv.setValueAsObject(value);
            nv.setQuotedValue();
        } else {
            nv = new NameValue(name, value);
            nv.setQuotedValue();
            this.parameters.set(nv);
        }
    }

    protected void setParameter(String name, int value) {
        Integer val = value;
        this.parameters.set(name, val);
    }

    protected void setParameter(String name, boolean value) {
        Boolean val = value;
        this.parameters.set(name, val);
    }

    protected void setParameter(String name, float value) {
        Float val = Float.valueOf(value);
        NameValue nv = this.parameters.getNameValue(name);
        if (nv != null) {
            nv.setValueAsObject(val);
        } else {
            nv = new NameValue(name, val);
            this.parameters.set(nv);
        }
    }

    protected void setParameter(String name, Object value) {
        this.parameters.set(name, value);
    }

    public boolean hasParameter(String parameterName) {
        return this.parameters.hasNameValue(parameterName);
    }

    public void removeParameters() {
        this.parameters = new NameValueList();
    }

    public NameValueList getParameters() {
        return this.parameters;
    }

    public void setParameter(NameValue nameValue) {
        this.parameters.set(nameValue);
    }

    public void setParameters(NameValueList parameters) {
        this.parameters = parameters;
    }

    protected int getParameterAsInt(String parameterName) {
        if (this.getParameterValue(parameterName) != null) {
            try {
                if (this.getParameterValue(parameterName) instanceof String) {
                    return Integer.parseInt(this.getParameter(parameterName));
                }
                return (Integer)this.getParameterValue(parameterName);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
        return -1;
    }

    protected int getParameterAsHexInt(String parameterName) {
        if (this.getParameterValue(parameterName) != null) {
            try {
                if (this.getParameterValue(parameterName) instanceof String) {
                    return Integer.parseInt(this.getParameter(parameterName), 16);
                }
                return (Integer)this.getParameterValue(parameterName);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
        return -1;
    }

    protected float getParameterAsFloat(String parameterName) {
        if (this.getParameterValue(parameterName) != null) {
            try {
                if (this.getParameterValue(parameterName) instanceof String) {
                    return Float.parseFloat(this.getParameter(parameterName));
                }
                return ((Float)this.getParameterValue(parameterName)).floatValue();
            }
            catch (NumberFormatException ex) {
                return -1.0f;
            }
        }
        return -1.0f;
    }

    protected long getParameterAsLong(String parameterName) {
        if (this.getParameterValue(parameterName) != null) {
            try {
                if (this.getParameterValue(parameterName) instanceof String) {
                    return Long.parseLong(this.getParameter(parameterName));
                }
                return (Long)this.getParameterValue(parameterName);
            }
            catch (NumberFormatException ex) {
                return -1L;
            }
        }
        return -1L;
    }

    protected GenericURI getParameterAsURI(String parameterName) {
        Object val = this.getParameterValue(parameterName);
        if (val instanceof GenericURI) {
            return (GenericURI)val;
        }
        try {
            return new GenericURI((String)val);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    protected boolean getParameterAsBoolean(String parameterName) {
        Object val = this.getParameterValue(parameterName);
        if (val == null) {
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return Boolean.valueOf((String)val);
        }
        return false;
    }

    public NameValue getNameValue(String parameterName) {
        return this.parameters.getNameValue(parameterName);
    }

    @Override
    public Object clone() {
        ParametersHeader retval = (ParametersHeader)super.clone();
        if (this.parameters != null) {
            retval.parameters = (NameValueList)this.parameters.clone();
        }
        return retval;
    }

    public void setMultiParameter(String name, String value) {
        NameValue nv = new NameValue();
        nv.setName(name);
        nv.setValue(value);
        this.duplicates.set(nv);
    }

    public void setMultiParameter(NameValue nameValue) {
        this.duplicates.set(nameValue);
    }

    public String getMultiParameter(String name) {
        return this.duplicates.getParameter(name);
    }

    public DuplicateNameValueList getMultiParameters() {
        return this.duplicates;
    }

    public Object getMultiParameterValue(String name) {
        return this.duplicates.getValue(name);
    }

    public Iterator<String> getMultiParameterNames() {
        return this.duplicates.getNames();
    }

    public boolean hasMultiParameters() {
        return this.duplicates != null && !this.duplicates.isEmpty();
    }

    public void removeMultiParameter(String name) {
        this.duplicates.delete(name);
    }

    public boolean hasMultiParameter(String parameterName) {
        return this.duplicates.hasNameValue(parameterName);
    }

    public void removeMultiParameters() {
        this.duplicates = new DuplicateNameValueList();
    }

    protected final boolean equalParameters(Parameters other) {
        String p2;
        String p1;
        String pname;
        if (this == other) {
            return true;
        }
        Iterator i2 = this.getParameterNames();
        while (i2.hasNext()) {
            pname = i2.next();
            p1 = this.getParameter(pname);
            if (p1 == null ^ (p2 = other.getParameter(pname)) == null) {
                return false;
            }
            if (p1 == null || p1.equalsIgnoreCase(p2)) continue;
            return false;
        }
        i2 = other.getParameterNames();
        while (i2.hasNext()) {
            pname = (String)i2.next();
            p1 = other.getParameter(pname);
            if (p1 == null ^ (p2 = this.getParameter(pname)) == null) {
                return false;
            }
            if (p1 == null || p1.equalsIgnoreCase(p2)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected abstract StringBuilder encodeBody(StringBuilder var1);
}

