/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.spans.json;

import com.newrelic.relocated.stream.JsonWriter;
import com.newrelic.telemetry.json.AttributesJson;
import com.newrelic.telemetry.spans.Span;
import com.newrelic.telemetry.spans.SpanBatch;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class SpanJsonTelemetryBlockWriter {
    private final AttributesJson attributesJson;

    public SpanJsonTelemetryBlockWriter(AttributesJson attributesJson) {
        this.attributesJson = attributesJson;
    }

    public void appendTelemetryJson(SpanBatch batch, JsonWriter jsonWriter) {
        try {
            jsonWriter.name("spans");
            jsonWriter.beginArray();
            Collection telemetry = batch.getTelemetry();
            for (Span span : telemetry) {
                jsonWriter.beginObject();
                jsonWriter.name("id").value(span.getId());
                if (span.getTraceId() != null) {
                    jsonWriter.name("trace.id").value(span.getTraceId());
                }
                jsonWriter.name("timestamp").value(span.getTimestamp());
                jsonWriter.name("attributes").jsonValue(this.attributesJson.toJson(this.enhanceAttributes(span)));
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate span telemetry json", e);
        }
    }

    private Map<String, Object> enhanceAttributes(Span span) {
        HashMap<String, Object> result2 = new HashMap<String, Object>(span.getAttributes().asMap());
        result2.putIfAbsent("name", span.getName());
        result2.putIfAbsent("parent.id", span.getParentId());
        result2.putIfAbsent("duration.ms", span.getDurationMs());
        result2.putIfAbsent("service.name", span.getServiceName());
        if (span.isError()) {
            result2.put("error", true);
        }
        return result2;
    }

    public AttributesJson getAttributesJson() {
        return this.attributesJson;
    }

    public String toString() {
        return "SpanJsonTelemetryBlockWriter{attributesJson=" + this.attributesJson + '}';
    }
}

