/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.micrometer.transform;

import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.metrics.Summary;
import com.newrelic.telemetry.micrometer.transform.AttributesMaker;
import com.newrelic.telemetry.micrometer.util.TimeTracker;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.Collections;

public class TimerTransformer {
    private final AttributesMaker attributesMaker = new AttributesMaker();
    private final TimeTracker timeTracker;

    public TimerTransformer(TimeTracker timeTracker) {
        this.timeTracker = timeTracker;
    }

    public Collection<Metric> transform(Timer timer) {
        Meter.Id id = timer.getId();
        long now = this.timeTracker.getCurrentTime();
        Summary summary = new Summary(id.getName(), (int)timer.count(), timer.totalTime(timer.baseTimeUnit()), Double.NaN, timer.max(timer.baseTimeUnit()), this.timeTracker.getPreviousTime(), now, this.attributesMaker.make(id, "timer"));
        return Collections.singleton(summary);
    }
}

