/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.memoize;

import groovy.lang.Closure;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import org.codehaus.groovy.runtime.memoize.LRUProtectionStorage;
import org.codehaus.groovy.runtime.memoize.MemoizeCache;
import org.codehaus.groovy.runtime.memoize.NullProtectionStorage;
import org.codehaus.groovy.runtime.memoize.ProtectionStorage;

public abstract class Memoize {
    private static final MemoizeNullValue MEMOIZE_NULL = new MemoizeNullValue();

    public static <V> Closure<V> buildMemoizeFunction(MemoizeCache<Object, Object> cache2, Closure<V> closure) {
        return new MemoizeFunction<V>(cache2, closure);
    }

    public static <V> Closure<V> buildSoftReferenceMemoizeFunction(int protectedCacheSize, MemoizeCache<Object, SoftReference<Object>> cache2, Closure<V> closure) {
        ProtectionStorage lruProtectionStorage = protectedCacheSize > 0 ? new LRUProtectionStorage(protectedCacheSize) : new NullProtectionStorage();
        ReferenceQueue queue = new ReferenceQueue();
        return new SoftReferenceMemoizeFunction<V>(cache2, closure, lruProtectionStorage, queue);
    }

    private static Object generateKey(Object[] args2) {
        if (args2 == null) {
            return Collections.emptyList();
        }
        Object[] copyOfArgs = Arrays.copyOf(args2, args2.length);
        return Arrays.asList(copyOfArgs);
    }

    private static class MemoizeNullValue {
        private MemoizeNullValue() {
        }

        public boolean equals(Object obj) {
            return obj instanceof MemoizeNullValue;
        }

        public int hashCode() {
            return "MemoizeNullValue".hashCode();
        }
    }

    private static class MemoizeFunction<V>
    extends Closure<V> {
        private static final long serialVersionUID = -2780003153676993093L;
        final MemoizeCache<Object, Object> cache;
        final Closure<V> closure;

        MemoizeFunction(MemoizeCache<Object, ?> cache2, Closure<V> closure) {
            super(closure.getOwner());
            this.cache = MemoizeFunction.coerce(cache2);
            this.closure = closure;
            this.parameterTypes = closure.getParameterTypes();
            this.maximumNumberOfParameters = closure.getMaximumNumberOfParameters();
        }

        private static MemoizeCache coerce(MemoizeCache<Object, ?> cache2) {
            return cache2;
        }

        @Override
        public V call(Object ... args2) {
            Object key = Memoize.generateKey(args2);
            Object result2 = this.cache.getAndPut(key, k -> {
                V r = this.closure.call(args2);
                return r != null ? r : MEMOIZE_NULL;
            });
            return (V)(result2 == MEMOIZE_NULL ? null : result2);
        }

        public V doCall(Object ... args2) {
            return this.call(args2);
        }
    }

    private static class SoftReferenceMemoizeFunction<V>
    extends MemoizeFunction<V> {
        private static final long serialVersionUID = -1338206227167457991L;
        final ProtectionStorage lruProtectionStorage;
        final ReferenceQueue queue;

        SoftReferenceMemoizeFunction(MemoizeCache<Object, SoftReference<Object>> cache2, Closure<V> closure, ProtectionStorage lruProtectionStorage, ReferenceQueue queue) {
            super(cache2, closure);
            this.lruProtectionStorage = lruProtectionStorage;
            this.queue = queue;
        }

        @Override
        public V call(Object ... args2) {
            if (this.queue.poll() != null) {
                SoftReferenceMemoizeFunction.cleanUpNullReferences(this.cache, this.queue);
            }
            Object key = Memoize.generateKey(args2);
            SoftReference reference = (SoftReference)this.cache.getAndPut(key, k -> {
                Object r = this.closure.call(args2);
                return null != r ? new SoftReference(r, this.queue) : new SoftReference<MemoizeNullValue>(MEMOIZE_NULL);
            });
            Object result2 = reference.get();
            this.lruProtectionStorage.touch(key, result2);
            return result2 == MEMOIZE_NULL ? null : (V)result2;
        }

        private static void cleanUpNullReferences(MemoizeCache<Object, Object> cache2, ReferenceQueue queue) {
            while (queue.poll() != null) {
            }
            cache2.cleanUpNullReferences();
        }
    }
}

