/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.micrometer.backends.BackendRegistries;
import java.util.Objects;

public class PrometheusScrapingHandlerImpl
implements Handler<RoutingContext> {
    private final String registryName;
    private final PrometheusMeterRegistry registry;

    public PrometheusScrapingHandlerImpl() {
        this.registryName = null;
        this.registry = null;
    }

    public PrometheusScrapingHandlerImpl(String registryName) {
        this.registryName = Objects.requireNonNull(registryName);
        this.registry = null;
    }

    public PrometheusScrapingHandlerImpl(PrometheusMeterRegistry registry) {
        this.registryName = null;
        this.registry = Objects.requireNonNull(registry);
    }

    @Override
    public void handle(RoutingContext rc) {
        if (this.registry != null) {
            PrometheusScrapingHandlerImpl.scrapeAndReply(rc, this.registry);
            return;
        }
        MeterRegistry registry = this.registryName == null ? BackendRegistries.getDefaultNow() : BackendRegistries.getNow(this.registryName);
        if (registry instanceof PrometheusMeterRegistry) {
            PrometheusScrapingHandlerImpl.scrapeAndReply(rc, (PrometheusMeterRegistry)registry);
        } else {
            String statusMessage = "Invalid registry: " + (registry != null ? registry.getClass().getName() : null);
            rc.response().setStatusCode(500).setStatusMessage(statusMessage).end();
        }
    }

    private static void scrapeAndReply(RoutingContext rc, PrometheusMeterRegistry prometheusMeterRegistry) {
        rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain; version=0.0.4; charset=utf-8").end(prometheusMeterRegistry.scrape());
    }
}

