/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.utils.JsonObjectHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class EnvVariablesConfigStore
implements ConfigStore {
    private final VertxInternal vertx;
    private final boolean rawData;
    private final Set<String> keys;
    private final Supplier<Map<String, String>> getenv;
    private final AtomicReference<Buffer> cached = new AtomicReference();

    public EnvVariablesConfigStore(Vertx vertx, boolean rawData, JsonArray keys2, Supplier<Map<String, String>> getenv) {
        this.vertx = (VertxInternal)vertx;
        this.rawData = rawData;
        this.keys = keys2 == null ? null : new HashSet(keys2.getList());
        this.getenv = getenv;
    }

    @Override
    public Future<Buffer> get() {
        Buffer value = this.cached.get();
        if (value == null) {
            value = EnvVariablesConfigStore.all(this.getenv.get(), this.rawData, this.keys).toBuffer();
            this.cached.set(value);
        }
        return this.vertx.getOrCreateContext().succeededFuture(value);
    }

    private static JsonObject all(Map<String, String> env, boolean rawData, Set<String> keys2) {
        JsonObject json = new JsonObject();
        Set<String> localKeys = keys2 == null ? env.keySet() : keys2;
        env.forEach((key, value) -> {
            if (localKeys.contains(key)) {
                JsonObjectHelper.put(json, key, value, rawData);
            }
        });
        return json;
    }

    @Override
    public Future<Void> close() {
        return this.vertx.getOrCreateContext().succeededFuture();
    }
}

