/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.management;

import io.netty.buffer.ByteBufUtil;
import io.sip3.commons.vertx.annotations.ConditionalOnProperty;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.salto.ce.management.AbstractServer;
import io.sip3.salto.ce.management.TcpServer;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.parsetools.RecordParser;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Instance(singleton=true)
@ConditionalOnProperty(pointer="/management", matcher=".*: ?\"?tcp://.*")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/sip3/salto/ce/management/TcpServer;", "Lio/sip3/salto/ce/management/AbstractServer;", "()V", "bufferSize", "", "Ljava/lang/Integer;", "delimiter", "", "logger", "Lmu/KLogger;", "sockets", "", "Ljava/net/URI;", "Lio/vertx/core/net/NetSocket;", "uri", "readConfig", "", "send", "message", "Lio/vertx/core/json/JsonObject;", "uris", "", "startServer", "tcpConnectionOptions", "Lio/vertx/core/net/NetServerOptions;", "sip3-salto-ce"})
public class TcpServer
extends AbstractServer {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    private URI uri;
    @Nullable
    private Integer bufferSize;
    @NotNull
    private String delimiter = "\r\n\r\n3PIS\r\n\r\n";
    @NotNull
    private final Map<URI, NetSocket> sockets = new LinkedHashMap();

    @Override
    public void readConfig() {
        block4: {
            JsonObject jsonObject;
            JsonObject jsonObject2 = this.config().getJsonObject("management");
            if (jsonObject2 == null) break block4;
            JsonObject management = jsonObject2;
            boolean bl = false;
            Object object = management.getJsonObject("tcp");
            JsonObject jsonObject3 = object;
            if (jsonObject3 == null) {
                jsonObject = management;
            } else {
                Intrinsics.checkNotNullExpressionValue(jsonObject3, "management.getJsonObject(\"tcp\") ?: management");
                jsonObject = object;
            }
            JsonObject config2 = jsonObject;
            Object object2 = object = config2.getString("uri");
            if (object2 == null) {
                throw new IllegalArgumentException("uri");
            }
            Intrinsics.checkNotNullExpressionValue(object2, "config.getString(\"uri\") \u2026lArgumentException(\"uri\")");
            this.uri = new URI((String)object);
            this.bufferSize = config2.getInteger("buffer_size");
            Object object3 = object = config2.getString("delimiter");
            if (object3 != null) {
                Intrinsics.checkNotNullExpressionValue(object3, "getString(\"delimiter\")");
                Object it = object;
                boolean bl2 = false;
                this.delimiter = it;
            }
        }
    }

    @Override
    public void startServer() {
        NetServerOptions options = this.tcpConnectionOptions();
        NetServer netServer = this.vertx.createNetServer(options).connectHandler(arg_0 -> TcpServer.startServer$lambda$5(this, arg_0));
        URI uRI = this.uri;
        if (uRI == null) {
            Intrinsics.throwUninitializedPropertyAccessException("uri");
            uRI = null;
        }
        int n = uRI.getPort();
        URI uRI2 = this.uri;
        if (uRI2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("uri");
            uRI2 = null;
        }
        netServer.listen(n, uRI2.getHost()).onFailure(arg_0 -> TcpServer.startServer$lambda$6(this, arg_0)).onSuccess(arg_0 -> TcpServer.startServer$lambda$7(this, arg_0));
    }

    @NotNull
    public NetServerOptions tcpConnectionOptions() {
        NetServerOptions netServerOptions;
        block0: {
            NetServerOptions $this$tcpConnectionOptions_u24lambda_u249 = netServerOptions = new NetServerOptions();
            boolean bl = false;
            Integer n = this.bufferSize;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$tcpConnectionOptions_u24lambda_u249.setReceiveBufferSize(it);
        }
        return netServerOptions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void send(@NotNull JsonObject message, @NotNull List<URI> uris) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(uris, "uris");
        Buffer buffer = message.toBuffer();
        Iterable $this$filter$iv = uris;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            URI it = (URI)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getScheme(), "tcp")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            NetSocket it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            URI it = (URI)element$iv$iv;
            boolean bl2 = false;
            if (this.sockets.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            NetSocket socket = (NetSocket)element$iv;
            boolean bl = false;
            socket.write(buffer.appendString(this.delimiter));
        }
    }

    private static final void startServer$lambda$5$lambda$2(TcpServer this$0, URI $senderUri, SocketAddress $sender, Buffer buffer) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($senderUri, "$senderUri");
        try {
            JsonObject jsonObject = buffer.toJsonObject();
            Intrinsics.checkNotNullExpressionValue(jsonObject, "buffer.toJsonObject()");
            this$0.handle($senderUri, jsonObject);
        }
        catch (Exception e) {
            this$0.logger.error(e, (Function0<? extends Object>)startServer.1.parser.1.1.INSTANCE);
            this$0.logger.debug((Function0<? extends Object>)new Function0<Object>($sender, buffer){
                final /* synthetic */ SocketAddress $sender;
                final /* synthetic */ Buffer $buffer;
                {
                    this.$sender = $sender;
                    this.$buffer = $buffer;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Sender: " + this.$sender + ", buffer: " + ByteBufUtil.prettyHexDump(this.$buffer.getByteBuf());
                }
            });
        }
    }

    private static final void startServer$lambda$5$lambda$3(RecordParser $parser, TcpServer this$0, SocketAddress $sender, Buffer buffer) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            $parser.handle(buffer);
        }
        catch (Exception e) {
            this$0.logger.error(e, (Function0<? extends Object>)startServer.1.2.1.INSTANCE);
            this$0.logger.debug((Function0<? extends Object>)new Function0<Object>($sender, buffer){
                final /* synthetic */ SocketAddress $sender;
                final /* synthetic */ Buffer $buffer;
                {
                    this.$sender = $sender;
                    this.$buffer = $buffer;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Sender: " + this.$sender + ", buffer: " + ByteBufUtil.prettyHexDump(this.$buffer.getByteBuf());
                }
            });
        }
    }

    private static final void startServer$lambda$5$lambda$4(TcpServer this$0, URI $senderUri, Void it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($senderUri, "$senderUri");
        this$0.sockets.remove($senderUri);
    }

    private static final void startServer$lambda$5(TcpServer this$0, NetSocket socket) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        SocketAddress sender = socket.remoteAddress();
        URI senderUri = new URI("tcp://" + sender.host() + ":" + sender.port());
        this$0.logger.debug((Function0<? extends Object>)new Function0<Object>(sender){
            final /* synthetic */ SocketAddress $sender;
            {
                this.$sender = $sender;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "TCP connection established from " + this.$sender;
            }
        });
        Map<URI, NetSocket> map2 = this$0.sockets;
        Intrinsics.checkNotNullExpressionValue(socket, "socket");
        map2.put(senderUri, socket);
        RecordParser parser2 = RecordParser.newDelimited(this$0.delimiter, arg_0 -> TcpServer.startServer$lambda$5$lambda$2(this$0, senderUri, sender, arg_0));
        socket.handler(arg_0 -> TcpServer.startServer$lambda$5$lambda$3(parser2, this$0, sender, arg_0));
        socket.closeHandler(arg_0 -> TcpServer.startServer$lambda$5$lambda$4(this$0, senderUri, arg_0));
    }

    private static final void startServer$lambda$6(TcpServer this$0, Throwable t) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.logger.error(t, (Function0<? extends Object>)new Function0<Object>(this$0){
            final /* synthetic */ TcpServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                URI uRI = TcpServer.access$getUri$p(this.this$0);
                if (uRI == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("uri");
                    uRI = null;
                }
                return "TCP connection failed. URI: " + uRI;
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, "t");
        throw t;
    }

    private static final void startServer$lambda$7(TcpServer this$0, NetServer it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.logger.info((Function0<? extends Object>)new Function0<Object>(this$0){
            final /* synthetic */ TcpServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                URI uRI = TcpServer.access$getUri$p(this.this$0);
                if (uRI == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("uri");
                    uRI = null;
                }
                return "Listening on " + uRI;
            }
        });
    }

    public static final /* synthetic */ URI access$getUri$p(TcpServer $this) {
        return $this.uri;
    }
}

