/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import io.sip3.logback.WebhookAppender;
import java.io.IOException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0002H\u0014J\u0010\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020\u001cH\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR+\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n $*\u0004\u0018\u00010#0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010%\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u001c8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b(\u0010\u0018\u001a\u0004\b&\u0010\u001e\"\u0004\b'\u0010 R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001e\"\u0004\b-\u0010 \u00a8\u00063"}, d2={"Lio/sip3/logback/WebhookAppender;", "Lch/qos/logback/core/UnsynchronizedAppenderBase;", "Lch/qos/logback/classic/spi/ILoggingEvent;", "()V", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "encoder", "Lch/qos/logback/core/encoder/Encoder;", "getEncoder", "()Lch/qos/logback/core/encoder/Encoder;", "setEncoder", "(Lch/qos/logback/core/encoder/Encoder;)V", "<set-?>", "", "interval", "getInterval", "()I", "setInterval", "(I)V", "interval$delegate", "Lkotlin/properties/ReadWriteProperty;", "intervalInMillis", "", "json", "", "getJson", "()Ljava/lang/String;", "setJson", "(Ljava/lang/String;)V", "lastSentAt", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "pattern", "getPattern", "setPattern", "pattern$delegate", "regex", "Lkotlin/text/Regex;", "url", "getUrl", "setUrl", "append", "", "event", "send", "message", "logback-webhook-appender"})
public final class WebhookAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private final Logger logger = LoggerFactory.getLogger(WebhookAppender.class);
    public Encoder<ILoggingEvent> encoder;
    public String url;
    public String json;
    @NotNull
    private final ReadWriteProperty interval$delegate;
    private long intervalInMillis;
    @NotNull
    private final ReadWriteProperty pattern$delegate;
    @NotNull
    private Regex regex;
    @NotNull
    private final Lazy client$delegate;
    private long lastSentAt;

    public WebhookAppender() {
        Delegates delegates = Delegates.INSTANCE;
        Object initialValue$iv = 60;
        boolean $i$f$observable = false;
        this.interval$delegate = new ObservableProperty<Integer>(initialValue$iv, this){
            final /* synthetic */ WebhookAppender this$0;
            {
                this.this$0 = webhookAppender;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter(property, "property");
                ((Number)newValue).intValue();
                ((Number)oldValue).intValue();
                boolean bl = false;
                WebhookAppender.access$setIntervalInMillis$p(this.this$0, (long)this.this$0.getInterval() * 1000L);
            }
        };
        this.intervalInMillis = (long)this.getInterval() * 1000L;
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = ".*";
        $i$f$observable = false;
        this.pattern$delegate = new ObservableProperty<String>(initialValue$iv, this){
            final /* synthetic */ WebhookAppender this$0;
            {
                this.this$0 = webhookAppender;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void v;
                Intrinsics.checkNotNullParameter(property, "property");
                String string = (String)newValue;
                String cfr_ignored_0 = (String)oldValue;
                boolean bl = false;
                WebhookAppender.access$setRegex$p(this.this$0, new Regex((String)v, RegexOption.DOT_MATCHES_ALL));
            }
        };
        this.regex = new Regex(this.getPattern(), RegexOption.DOT_MATCHES_ALL);
        this.client$delegate = LazyKt.lazy(client.2.INSTANCE);
    }

    @NotNull
    public final Encoder<ILoggingEvent> getEncoder() {
        Encoder<ILoggingEvent> encoder = this.encoder;
        if (encoder != null) {
            return encoder;
        }
        Intrinsics.throwUninitializedPropertyAccessException("encoder");
        return null;
    }

    public final void setEncoder(@NotNull Encoder<ILoggingEvent> encoder) {
        Intrinsics.checkNotNullParameter(encoder, "<set-?>");
        this.encoder = encoder;
    }

    @NotNull
    public final String getUrl() {
        String string = this.url;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("url");
        return null;
    }

    public final void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.url = string;
    }

    @NotNull
    public final String getJson() {
        String string = this.json;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("json");
        return null;
    }

    public final void setJson(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.json = string;
    }

    public final int getInterval() {
        return ((Number)this.interval$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    public final void setInterval(int n) {
        this.interval$delegate.setValue(this, $$delegatedProperties[0], n);
    }

    @NotNull
    public final String getPattern() {
        return (String)this.pattern$delegate.getValue(this, $$delegatedProperties[1]);
    }

    public final void setPattern(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.pattern$delegate.setValue(this, $$delegatedProperties[1], string);
    }

    private final OkHttpClient getClient() {
        Lazy lazy = this.client$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    @Override
    protected void append(@NotNull ILoggingEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!Intrinsics.areEqual(event.getLevel(), Level.ERROR)) {
            return;
        }
        if (event.getTimeStamp() < this.lastSentAt + this.intervalInMillis) {
            return;
        }
        byte[] byArray = this.getEncoder().encode(event);
        Intrinsics.checkNotNullExpressionValue(byArray, "encoder.encode(event)");
        Object object = byArray;
        String message = new String((byte[])object, Charsets.UTF_8);
        object = message;
        if (this.regex.matches((CharSequence)object)) {
            this.send(message);
            this.lastSentAt = event.getTimeStamp();
        }
    }

    private final void send(String message) {
        String string = this.getJson();
        String string2 = StringEscapeUtils.escapeJson(message);
        Intrinsics.checkNotNullExpressionValue(string2, "escapeJson(message)");
        String payload = StringsKt.replace$default(string, "{message}", string2, false, 4, null);
        Request request = new Request.Builder().url(this.getUrl()).post(RequestBody.Companion.create(payload, MediaType.Companion.get("application/json; charset=utf-8"))).build();
        this.getClient().newCall(request).enqueue(new Callback(this, payload){
            final /* synthetic */ WebhookAppender this$0;
            final /* synthetic */ String $payload;
            {
                this.this$0 = $receiver;
                this.$payload = $payload;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter(call, "call");
                Intrinsics.checkNotNullParameter(e, "e");
                WebhookAppender.access$getLogger$p(this.this$0).error("Webhook call failed. URL: " + this.this$0.getUrl() + ", Payload: " + this.$payload, e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter(call, "call");
                Intrinsics.checkNotNullParameter(response, "response");
            }
        });
    }

    public static final /* synthetic */ Logger access$getLogger$p(WebhookAppender $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$setIntervalInMillis$p(WebhookAppender $this, long l) {
        $this.intervalInMillis = l;
    }

    public static final /* synthetic */ void access$setRegex$p(WebhookAppender $this, Regex regex) {
        $this.regex = regex;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(WebhookAppender.class, "interval", "getInterval()I", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(WebhookAppender.class, "pattern", "getPattern()Ljava/lang/String;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

