/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry;

import com.newrelic.telemetry.BaseConfig;
import com.newrelic.telemetry.http.HttpPoster;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class SenderConfiguration {
    private static final String DEFAULT_US_REGION = "US";
    private final BaseConfig baseConfig;
    private final HttpPoster httpPoster;
    private final URL endpointUrl;
    private final boolean useLicenseKey;
    private final String endpointRegion;

    public SenderConfiguration(String apiKey, HttpPoster httpPoster, URL endpointUrl, boolean auditLoggingEnabled, String secondaryUserAgent) {
        this(apiKey, httpPoster, endpointUrl, auditLoggingEnabled, secondaryUserAgent, false, DEFAULT_US_REGION);
    }

    public SenderConfiguration(String apiKey, HttpPoster httpPoster, URL endpointUrl, boolean auditLoggingEnabled, String secondaryUserAgent, boolean useLicenseKey, String endpointRegion) {
        this.httpPoster = httpPoster;
        this.endpointUrl = endpointUrl;
        this.baseConfig = new BaseConfig(apiKey, auditLoggingEnabled, secondaryUserAgent);
        this.useLicenseKey = useLicenseKey;
        this.endpointRegion = endpointRegion;
    }

    public String getApiKey() {
        return this.baseConfig.getApiKey();
    }

    public HttpPoster getHttpPoster() {
        return this.httpPoster;
    }

    public URL getEndpointUrl() {
        return this.endpointUrl;
    }

    public boolean isAuditLoggingEnabled() {
        return this.baseConfig.isAuditLoggingEnabled();
    }

    public String getSecondaryUserAgent() {
        return this.baseConfig.getSecondaryUserAgent();
    }

    public boolean useLicenseKey() {
        return this.useLicenseKey;
    }

    public String getRegion() {
        return this.endpointRegion;
    }

    public static SenderConfigurationBuilder builder(String defaultUrl, String basePath) {
        return new SenderConfigurationBuilder(defaultUrl, basePath);
    }

    public static class SenderConfigurationBuilder {
        private final String defaultUrl;
        private final String basePath;
        private String apiKey;
        private HttpPoster httpPoster;
        private URL endpointUrl;
        private boolean auditLoggingEnabled = false;
        private boolean useLicenseKey = false;
        private String endpointRegion = "US";
        private String secondaryUserAgent;

        public SenderConfigurationBuilder(String defaultUrl, String basePath) {
            this.defaultUrl = defaultUrl;
            this.basePath = basePath;
        }

        public SenderConfigurationBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public SenderConfigurationBuilder httpPoster(HttpPoster httpPoster) {
            this.httpPoster = httpPoster;
            return this;
        }

        public SenderConfigurationBuilder endpoint(URL endpoint) {
            this.endpointUrl = endpoint;
            return this;
        }

        public SenderConfigurationBuilder useLicenseKey(boolean useLicenseKey) {
            this.useLicenseKey = useLicenseKey;
            return this;
        }

        public SenderConfigurationBuilder setRegion(String region) throws IllegalArgumentException {
            if (!(region = region.toUpperCase()).equals(SenderConfiguration.DEFAULT_US_REGION) && !region.equals("EU")) {
                throw new IllegalArgumentException("The only supported regions are the US and EU regions");
            }
            this.endpointRegion = region;
            return this;
        }

        public SenderConfigurationBuilder auditLoggingEnabled(boolean auditLoggingEnabled) {
            this.auditLoggingEnabled = auditLoggingEnabled;
            return this;
        }

        public SenderConfigurationBuilder secondaryUserAgent(String secondaryUserAgent) {
            this.secondaryUserAgent = secondaryUserAgent;
            return this;
        }

        public SenderConfiguration build() {
            return new SenderConfiguration(this.apiKey, this.httpPoster, this.getOrDefaultSendUrl(), this.auditLoggingEnabled, this.secondaryUserAgent, this.useLicenseKey, this.endpointRegion);
        }

        private URL getOrDefaultSendUrl() {
            try {
                if (this.endpointUrl != null) {
                    return this.endpointUrl;
                }
                return this.constructUrlWithHost(URI.create(this.defaultUrl));
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException("Bad Hardcoded URL " + this.defaultUrl, e);
            }
        }

        public URL constructUrlWithHost(URI hostUri) throws MalformedURLException {
            return hostUri.resolve(this.basePath).toURL();
        }
    }
}

