/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropCollectionOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.operation.AsyncExplainableReadOperation;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.MapReduceAsyncBatchCursor;
import com.mongodb.internal.operation.MapReduceStatistics;
import com.mongodb.internal.operation.Operations;
import java.util.List;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class AsyncOperations<TDocument> {
    private final Operations<TDocument> operations;

    public AsyncOperations(MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads) {
        this.operations = new Operations<TDocument>(namespace, documentClass, readPreference, codecRegistry, readConcern, writeConcern, retryWrites, retryReads);
    }

    public MongoNamespace getNamespace() {
        return this.operations.getNamespace();
    }

    public Class<TDocument> getDocumentClass() {
        return this.operations.getDocumentClass();
    }

    public ReadPreference getReadPreference() {
        return this.operations.getReadPreference();
    }

    public CodecRegistry getCodecRegistry() {
        return this.operations.getCodecRegistry();
    }

    public ReadConcern getReadConcern() {
        return this.operations.getReadConcern();
    }

    public WriteConcern getWriteConcern() {
        return this.operations.getWriteConcern();
    }

    public boolean isRetryWrites() {
        return this.operations.isRetryWrites();
    }

    public boolean isRetryReads() {
        return this.operations.isRetryReads();
    }

    public AsyncReadOperation<Long> countDocuments(Bson filter2, CountOptions options) {
        return this.operations.countDocuments(filter2, options);
    }

    public AsyncReadOperation<Long> estimatedDocumentCount(EstimatedDocumentCountOptions options) {
        return this.operations.estimatedDocumentCount(options);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> findFirst(Bson filter2, Class<TResult> resultClass, FindOptions options) {
        return this.operations.findFirst(filter2, resultClass, options);
    }

    public <TResult> AsyncExplainableReadOperation<AsyncBatchCursor<TResult>> find(Bson filter2, Class<TResult> resultClass, FindOptions options) {
        return this.operations.find(filter2, resultClass, options);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> find(MongoNamespace findNamespace, Bson filter2, Class<TResult> resultClass, FindOptions options) {
        return this.operations.find(findNamespace, filter2, resultClass, options);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> distinct(String fieldName, Bson filter2, Class<TResult> resultClass, long maxTimeMS, Collation collation, BsonValue comment) {
        return this.operations.distinct(fieldName, filter2, resultClass, maxTimeMS, collation, comment);
    }

    public <TResult> AsyncExplainableReadOperation<AsyncBatchCursor<TResult>> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass, long maxTimeMS, long maxAwaitTimeMS, Integer batchSize, Collation collation, Bson hint, String hintString, BsonValue comment, Bson variables, Boolean allowDiskUse, AggregationLevel aggregationLevel) {
        return this.operations.aggregate(pipeline, resultClass, maxTimeMS, maxAwaitTimeMS, batchSize, collation, hint, hintString, comment, variables, allowDiskUse, aggregationLevel);
    }

    public AsyncReadOperation<Void> aggregateToCollection(List<? extends Bson> pipeline, long maxTimeMS, Boolean allowDiskUse, Boolean bypassDocumentValidation, Collation collation, Bson hint, String hintString, BsonValue comment, Bson variables, AggregationLevel aggregationLevel) {
        return this.operations.aggregateToCollection(pipeline, maxTimeMS, allowDiskUse, bypassDocumentValidation, collation, hint, hintString, comment, variables, aggregationLevel);
    }

    public AsyncWriteOperation<MapReduceStatistics> mapReduceToCollection(String databaseName, String collectionName, String mapFunction, String reduceFunction, String finalizeFunction, Bson filter2, int limit, long maxTimeMS, boolean jsMode, Bson scope, Bson sort, boolean verbose, MapReduceAction action, boolean nonAtomic, boolean sharded, Boolean bypassDocumentValidation, Collation collation) {
        return this.operations.mapReduceToCollection(databaseName, collectionName, mapFunction, reduceFunction, finalizeFunction, filter2, limit, maxTimeMS, jsMode, scope, sort, verbose, action, nonAtomic, sharded, bypassDocumentValidation, collation);
    }

    public <TResult> AsyncReadOperation<MapReduceAsyncBatchCursor<TResult>> mapReduce(String mapFunction, String reduceFunction, String finalizeFunction, Class<TResult> resultClass, Bson filter2, int limit, long maxTimeMS, boolean jsMode, Bson scope, Bson sort, boolean verbose, Collation collation) {
        return this.operations.mapReduce(mapFunction, reduceFunction, finalizeFunction, resultClass, filter2, limit, maxTimeMS, jsMode, scope, sort, verbose, collation);
    }

    public AsyncWriteOperation<TDocument> findOneAndDelete(Bson filter2, FindOneAndDeleteOptions options) {
        return this.operations.findOneAndDelete(filter2, options);
    }

    public AsyncWriteOperation<TDocument> findOneAndReplace(Bson filter2, TDocument replacement, FindOneAndReplaceOptions options) {
        return this.operations.findOneAndReplace(filter2, replacement, options);
    }

    public AsyncWriteOperation<TDocument> findOneAndUpdate(Bson filter2, Bson update, FindOneAndUpdateOptions options) {
        return this.operations.findOneAndUpdate(filter2, update, options);
    }

    public AsyncWriteOperation<TDocument> findOneAndUpdate(Bson filter2, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return this.operations.findOneAndUpdate(filter2, update, options);
    }

    public AsyncWriteOperation<BulkWriteResult> insertOne(TDocument document, InsertOneOptions options) {
        return this.operations.insertOne(document, options);
    }

    public AsyncWriteOperation<BulkWriteResult> replaceOne(Bson filter2, TDocument replacement, ReplaceOptions options) {
        return this.operations.replaceOne(filter2, replacement, options);
    }

    public AsyncWriteOperation<BulkWriteResult> deleteOne(Bson filter2, DeleteOptions options) {
        return this.operations.deleteOne(filter2, options);
    }

    public AsyncWriteOperation<BulkWriteResult> deleteMany(Bson filter2, DeleteOptions options) {
        return this.operations.deleteMany(filter2, options);
    }

    public AsyncWriteOperation<BulkWriteResult> updateOne(Bson filter2, Bson update, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter2, update, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> updateOne(Bson filter2, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter2, update, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> updateMany(Bson filter2, Bson update, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter2, update, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> updateMany(Bson filter2, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter2, update, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> insertMany(List<? extends TDocument> documents, InsertManyOptions options) {
        return this.operations.insertMany(documents, options);
    }

    public AsyncWriteOperation<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        return this.operations.bulkWrite(requests, options);
    }

    public AsyncWriteOperation<Void> dropCollection(DropCollectionOptions dropCollectionOptions, AutoEncryptionSettings autoEncryptionSettings) {
        return this.operations.dropCollection(dropCollectionOptions, autoEncryptionSettings);
    }

    public AsyncWriteOperation<Void> renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return this.operations.renameCollection(newCollectionNamespace, options);
    }

    public AsyncWriteOperation<Void> createIndexes(List<IndexModel> indexes, CreateIndexOptions options) {
        return this.operations.createIndexes(indexes, options);
    }

    public AsyncWriteOperation<Void> dropIndex(String indexName, DropIndexOptions options) {
        return this.operations.dropIndex(indexName, options);
    }

    public AsyncWriteOperation<Void> dropIndex(Bson keys2, DropIndexOptions options) {
        return this.operations.dropIndex(keys2, options);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listCollections(String databaseName, Class<TResult> resultClass, Bson filter2, boolean collectionNamesOnly, Integer batchSize, long maxTimeMS, BsonValue comment) {
        return this.operations.listCollections(databaseName, resultClass, filter2, collectionNamesOnly, batchSize, maxTimeMS, comment);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listDatabases(Class<TResult> resultClass, Bson filter2, Boolean nameOnly, long maxTimeMS, Boolean authorizedDatabases, BsonValue comment) {
        return this.operations.listDatabases(resultClass, filter2, nameOnly, maxTimeMS, authorizedDatabases, comment);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listIndexes(Class<TResult> resultClass, Integer batchSize, long maxTimeMS, BsonValue comment) {
        return this.operations.listIndexes(resultClass, batchSize, maxTimeMS, comment);
    }
}

