/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.spi.format;

import org.restcomm.media.spi.format.ApplicationFormat;
import org.restcomm.media.spi.format.AudioFormat;
import org.restcomm.media.spi.format.EncodingName;
import org.restcomm.media.spi.format.VideoFormat;
import org.restcomm.media.spi.format.audio.DTMFFormat;
import org.restcomm.media.spi.utils.Text;

public class FormatFactory {
    private static Text DTMF = new Text("telephone-event");

    public static AudioFormat createAudioFormat(EncodingName name) {
        if (name.equals(DTMF)) {
            return new DTMFFormat();
        }
        return new AudioFormat(name);
    }

    public static AudioFormat createAudioFormat(EncodingName name, int sampleRate, int sampleSize, int channels) {
        AudioFormat fmt = FormatFactory.createAudioFormat(name);
        fmt.setSampleRate(sampleRate);
        fmt.setSampleSize(sampleSize);
        fmt.setChannels(channels);
        return fmt;
    }

    public static AudioFormat createAudioFormat(String name, int sampleRate, int sampleSize, int channels) {
        AudioFormat fmt = FormatFactory.createAudioFormat(new EncodingName(name));
        fmt.setSampleRate(sampleRate);
        fmt.setSampleSize(sampleSize);
        fmt.setChannels(channels);
        return fmt;
    }

    public static AudioFormat createAudioFormat(String name, int sampleRate) {
        AudioFormat fmt = FormatFactory.createAudioFormat(new EncodingName(name));
        fmt.setSampleRate(sampleRate);
        return fmt;
    }

    public static VideoFormat createVideoFormat(EncodingName name, int frameRate) {
        return new VideoFormat(name, frameRate);
    }

    public static VideoFormat createVideoFormat(EncodingName name) {
        return new VideoFormat(name);
    }

    public static VideoFormat createVideoFormat(String name) {
        return new VideoFormat(name);
    }

    public static VideoFormat createVideoFormat(String name, int frameRate) {
        return new VideoFormat(name, frameRate);
    }

    public static ApplicationFormat createApplicationFormat(EncodingName name) {
        return new ApplicationFormat(name);
    }

    public static ApplicationFormat createApplicationFormat(String name) {
        return new ApplicationFormat(name);
    }
}

