/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import java.util.LinkedList;

public class StringHelper {
    private static final char SPACE = ' ';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String[] tokenizeUnquoted(String s) {
        LinkedList<String> tokens = new LinkedList<String>();
        int first2 = 0;
        while (first2 < s.length()) {
            int last2;
            if ((first2 = StringHelper.skipWhitespace(s, first2)) < (last2 = StringHelper.scanToken(s, first2))) {
                tokens.add(s.substring(first2, last2));
            }
            first2 = last2;
        }
        return tokens.toArray(EMPTY_STRING_ARRAY);
    }

    private static int scanToken(String s, int pos0) {
        char c;
        int pos = pos0;
        while (pos < s.length() && ' ' != (c = s.charAt(pos))) {
            ++pos;
            if ('\'' == c) {
                pos = StringHelper.scanQuoted(s, pos, '\'');
                continue;
            }
            if ('\"' != c) continue;
            pos = StringHelper.scanQuoted(s, pos, '\"');
        }
        return pos;
    }

    private static int scanQuoted(String s, int pos0, char quote) {
        char c;
        int pos = pos0;
        while (pos < s.length() && quote != (c = s.charAt(pos++))) {
        }
        return pos;
    }

    private static int skipWhitespace(String s, int pos0) {
        char c;
        int pos;
        for (pos = pos0; pos < s.length() && ' ' == (c = s.charAt(pos)); ++pos) {
        }
        return pos;
    }
}

