/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.junit5.ScopedObject;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtensionParameterProvider;
import io.vertx.junit5.VertxTestContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.DynamicTestInvocationContext;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

public final class VertxExtension
implements ParameterResolver,
InvocationInterceptor {
    public static final int DEFAULT_TIMEOUT_DURATION = 30;
    public static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    public static final String VERTX_INSTANCE_KEY = "Vertx";
    private static final String TEST_CONTEXT_KEY = "VertxTestContext";
    private final HashMap<Class<?>, VertxExtensionParameterProvider<?>> parameterProviders = new HashMap();

    public VertxExtension() {
        for (VertxExtensionParameterProvider parameterProvider : ServiceLoader.load(VertxExtensionParameterProvider.class)) {
            this.parameterProviders.put(parameterProvider.type(), parameterProvider);
        }
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.parameterProviders.keySet().contains(this.parameterType(parameterContext));
    }

    private Class<?> parameterType(ParameterContext parameterContext) {
        return parameterContext.getParameter().getType();
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ExtensionContext.Store parentStore;
        Class<?> type = this.parameterType(parameterContext);
        VertxExtensionParameterProvider<?> parameterProvider = this.parameterProviders.get(type);
        if (type.equals(VertxTestContext.class)) {
            return this.newTestContext(extensionContext);
        }
        if (extensionContext.getParent().isPresent() && (parentStore = this.store(extensionContext.getParent().get())).get(parameterProvider.key()) != null) {
            return VertxExtension.unpack(parentStore.get(parameterProvider.key()));
        }
        ExtensionContext.Store store = this.store(extensionContext);
        return VertxExtension.unpack(store.getOrComputeIfAbsent(parameterProvider.key(), key -> new ScopedObject(parameterProvider.newInstance(extensionContext, parameterContext), parameterProvider.parameterClosingConsumer())));
    }

    private static Object unpack(Object object) {
        if (object instanceof Supplier) {
            return ((Supplier)object).get();
        }
        return object;
    }

    private VertxTestContext newTestContext(ExtensionContext extensionContext) {
        ExtensionContext.Store store = this.store(extensionContext);
        ContextList contexts = (ContextList)store.getOrComputeIfAbsent(TEST_CONTEXT_KEY, key -> new ContextList());
        VertxTestContext newTestContext = new VertxTestContext();
        contexts.add(newTestContext);
        return newTestContext;
    }

    private ExtensionContext.Store store(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.GLOBAL);
    }

    @Override
    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        invocation.proceed();
        this.joinActiveTestContexts(extensionContext);
    }

    @Override
    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        invocation.proceed();
        this.joinActiveTestContexts(extensionContext);
    }

    @Override
    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        invocation.proceed();
        this.joinActiveTestContexts(extensionContext);
    }

    @Override
    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        invocation.proceed();
        this.joinActiveTestContexts(extensionContext);
    }

    @Override
    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        invocation.proceed();
        this.joinActiveTestContexts(extensionContext);
    }

    @Override
    public void interceptDynamicTest(InvocationInterceptor.Invocation<Void> invocation, DynamicTestInvocationContext invocationContext, ExtensionContext extensionContext) throws Throwable {
        invocation.proceed();
        this.joinActiveTestContexts(extensionContext);
    }

    @Override
    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        invocation.proceed();
        this.joinActiveTestContexts(extensionContext);
    }

    private void joinActiveTestContexts(ExtensionContext extensionContext) throws Exception {
        if (extensionContext.getExecutionException().isPresent()) {
            return;
        }
        ContextList currentContexts = this.store(extensionContext).remove(TEST_CONTEXT_KEY, ContextList.class);
        if (currentContexts != null) {
            for (VertxTestContext context : currentContexts) {
                int timeoutDuration = 30;
                TimeUnit timeoutUnit = DEFAULT_TIMEOUT_UNIT;
                Optional<Method> testMethod = extensionContext.getTestMethod();
                if (testMethod.isPresent() && testMethod.get().isAnnotationPresent(Timeout.class)) {
                    Timeout annotation = extensionContext.getRequiredTestMethod().getAnnotation(Timeout.class);
                    timeoutDuration = annotation.value();
                    timeoutUnit = annotation.timeUnit();
                } else {
                    Class<?> testClass = extensionContext.getRequiredTestClass();
                    while (testClass != null) {
                        if (testClass.isAnnotationPresent(Timeout.class)) {
                            Timeout annotation = testClass.getAnnotation(Timeout.class);
                            timeoutDuration = annotation.value();
                            timeoutUnit = annotation.timeUnit();
                            break;
                        }
                        testClass = testClass.isAnnotationPresent(Nested.class) ? testClass.getEnclosingClass() : null;
                    }
                }
                if (context.awaitCompletion(timeoutDuration, timeoutUnit)) {
                    if (!context.failed()) continue;
                    Throwable throwable = context.causeOfFailure();
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    throw new AssertionError((Object)throwable);
                }
                String message = "The test execution timed out. Make sure your asynchronous code includes calls to either VertxTestContext#completeNow(), VertxTestContext#failNow() or Checkpoint#flag()";
                message = message + context.unsatisfiedCheckpointCallSites().stream().map(element -> String.format("-> checkpoint at %s", element)).collect(Collectors.joining("\n", "\n\nUnsatisfied checkpoints diagnostics:\n", ""));
                throw new TimeoutException(message);
            }
        }
        if (extensionContext.getParent().isPresent()) {
            this.joinActiveTestContexts(extensionContext.getParent().get());
        }
    }

    private static class ContextList
    extends ArrayList<VertxTestContext> {
        private ContextList() {
        }
    }
}

