/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.WriteConcern;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.TimeUnit;

class WriteConcernParser {
    private final WriteConcern writeConcern;

    WriteConcernParser(ConnectionString connectionString, JsonObject config2) {
        WriteConcern writeConcern = this.fromConfig(config2);
        if (writeConcern == null && connectionString != null) {
            writeConcern = connectionString.getWriteConcern();
        }
        this.writeConcern = writeConcern;
    }

    private WriteConcern fromConfig(JsonObject config2) {
        WriteConcern writeConcern = null;
        String wcs = config2.getString("writeConcern");
        if (wcs != null) {
            writeConcern = WriteConcern.valueOf(wcs);
            if (writeConcern == null) {
                throw new IllegalArgumentException("Invalid WriteConcern " + wcs);
            }
        } else {
            Boolean safe = config2.getBoolean("safe");
            Object w = config2.getValue("w");
            Integer wtimeout = config2.getInteger("wtimeoutMS", null);
            Boolean j = config2.getBoolean("j", null);
            if (j == null) {
                j = config2.getBoolean("journal", null);
            }
            if (w != null || wtimeout != null || j != null && j.booleanValue()) {
                writeConcern = w == null ? new WriteConcern(1) : this.getWriteConcern(w);
                if (wtimeout != null) {
                    writeConcern = writeConcern.withWTimeout(wtimeout.intValue(), TimeUnit.MILLISECONDS);
                }
                if (j != null) {
                    writeConcern = writeConcern.withJournal(j);
                }
            } else if (safe != null) {
                writeConcern = safe != false ? WriteConcern.ACKNOWLEDGED : WriteConcern.UNACKNOWLEDGED;
            }
        }
        return writeConcern;
    }

    private WriteConcern getWriteConcern(Object w) {
        WriteConcern wc;
        if (w instanceof String) {
            wc = new WriteConcern((String)w);
        } else if (w instanceof Integer) {
            wc = new WriteConcern((Integer)w);
        } else {
            throw new IllegalArgumentException("Invalid type " + w.getClass() + " for w of WriteConcern");
        }
        return wc;
    }

    WriteConcern writeConcern() {
        return this.writeConcern;
    }
}

