/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.Expectation;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpResponseHead;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface HttpResponseExpectation
extends Expectation<HttpResponseHead> {
    public static final HttpResponseExpectation SC_INFORMATIONAL_RESPONSE = HttpResponseExpectation.status(100, 200);
    public static final HttpResponseExpectation SC_CONTINUE = HttpResponseExpectation.status(100);
    public static final HttpResponseExpectation SC_SWITCHING_PROTOCOLS = HttpResponseExpectation.status(101);
    public static final HttpResponseExpectation SC_PROCESSING = HttpResponseExpectation.status(102);
    public static final HttpResponseExpectation SC_EARLY_HINTS = HttpResponseExpectation.status(103);
    public static final HttpResponseExpectation SC_SUCCESS = HttpResponseExpectation.status(200, 300);
    public static final HttpResponseExpectation SC_OK = HttpResponseExpectation.status(200);
    public static final HttpResponseExpectation SC_CREATED = HttpResponseExpectation.status(201);
    public static final HttpResponseExpectation SC_ACCEPTED = HttpResponseExpectation.status(202);
    public static final HttpResponseExpectation SC_NON_AUTHORITATIVE_INFORMATION = HttpResponseExpectation.status(203);
    public static final HttpResponseExpectation SC_NO_CONTENT = HttpResponseExpectation.status(204);
    public static final HttpResponseExpectation SC_RESET_CONTENT = HttpResponseExpectation.status(205);
    public static final HttpResponseExpectation SC_PARTIAL_CONTENT = HttpResponseExpectation.status(206);
    public static final HttpResponseExpectation SC_MULTI_STATUS = HttpResponseExpectation.status(207);
    public static final HttpResponseExpectation SC_REDIRECTION = HttpResponseExpectation.status(300, 400);
    public static final HttpResponseExpectation SC_MULTIPLE_CHOICES = HttpResponseExpectation.status(300);
    public static final HttpResponseExpectation SC_MOVED_PERMANENTLY = HttpResponseExpectation.status(301);
    public static final HttpResponseExpectation SC_FOUND = HttpResponseExpectation.status(302);
    public static final HttpResponseExpectation SC_SEE_OTHER = HttpResponseExpectation.status(303);
    public static final HttpResponseExpectation SC_NOT_MODIFIED = HttpResponseExpectation.status(304);
    public static final HttpResponseExpectation SC_USE_PROXY = HttpResponseExpectation.status(305);
    public static final HttpResponseExpectation SC_TEMPORARY_REDIRECT = HttpResponseExpectation.status(307);
    public static final HttpResponseExpectation SC_PERMANENT_REDIRECT = HttpResponseExpectation.status(308);
    public static final HttpResponseExpectation SC_CLIENT_ERRORS = HttpResponseExpectation.status(400, 500);
    public static final HttpResponseExpectation SC_BAD_REQUEST = HttpResponseExpectation.status(400);
    public static final HttpResponseExpectation SC_UNAUTHORIZED = HttpResponseExpectation.status(401);
    public static final HttpResponseExpectation SC_PAYMENT_REQUIRED = HttpResponseExpectation.status(402);
    public static final HttpResponseExpectation SC_FORBIDDEN = HttpResponseExpectation.status(403);
    public static final HttpResponseExpectation SC_NOT_FOUND = HttpResponseExpectation.status(404);
    public static final HttpResponseExpectation SC_METHOD_NOT_ALLOWED = HttpResponseExpectation.status(405);
    public static final HttpResponseExpectation SC_NOT_ACCEPTABLE = HttpResponseExpectation.status(406);
    public static final HttpResponseExpectation SC_PROXY_AUTHENTICATION_REQUIRED = HttpResponseExpectation.status(407);
    public static final HttpResponseExpectation SC_REQUEST_TIMEOUT = HttpResponseExpectation.status(408);
    public static final HttpResponseExpectation SC_CONFLICT = HttpResponseExpectation.status(409);
    public static final HttpResponseExpectation SC_GONE = HttpResponseExpectation.status(410);
    public static final HttpResponseExpectation SC_LENGTH_REQUIRED = HttpResponseExpectation.status(411);
    public static final HttpResponseExpectation SC_PRECONDITION_FAILED = HttpResponseExpectation.status(412);
    public static final HttpResponseExpectation SC_REQUEST_ENTITY_TOO_LARGE = HttpResponseExpectation.status(413);
    public static final HttpResponseExpectation SC_REQUEST_URI_TOO_LONG = HttpResponseExpectation.status(414);
    public static final HttpResponseExpectation SC_UNSUPPORTED_MEDIA_TYPE = HttpResponseExpectation.status(415);
    public static final HttpResponseExpectation SC_REQUESTED_RANGE_NOT_SATISFIABLE = HttpResponseExpectation.status(416);
    public static final HttpResponseExpectation SC_EXPECTATION_FAILED = HttpResponseExpectation.status(417);
    public static final HttpResponseExpectation SC_MISDIRECTED_REQUEST = HttpResponseExpectation.status(421);
    public static final HttpResponseExpectation SC_UNPROCESSABLE_ENTITY = HttpResponseExpectation.status(422);
    public static final HttpResponseExpectation SC_LOCKED = HttpResponseExpectation.status(423);
    public static final HttpResponseExpectation SC_FAILED_DEPENDENCY = HttpResponseExpectation.status(424);
    public static final HttpResponseExpectation SC_UNORDERED_COLLECTION = HttpResponseExpectation.status(425);
    public static final HttpResponseExpectation SC_UPGRADE_REQUIRED = HttpResponseExpectation.status(426);
    public static final HttpResponseExpectation SC_PRECONDITION_REQUIRED = HttpResponseExpectation.status(428);
    public static final HttpResponseExpectation SC_TOO_MANY_REQUESTS = HttpResponseExpectation.status(429);
    public static final HttpResponseExpectation SC_REQUEST_HEADER_FIELDS_TOO_LARGE = HttpResponseExpectation.status(431);
    public static final HttpResponseExpectation SC_SERVER_ERRORS = HttpResponseExpectation.status(500, 600);
    public static final HttpResponseExpectation SC_INTERNAL_SERVER_ERROR = HttpResponseExpectation.status(500);
    public static final HttpResponseExpectation SC_NOT_IMPLEMENTED = HttpResponseExpectation.status(501);
    public static final HttpResponseExpectation SC_BAD_GATEWAY = HttpResponseExpectation.status(502);
    public static final HttpResponseExpectation SC_SERVICE_UNAVAILABLE = HttpResponseExpectation.status(503);
    public static final HttpResponseExpectation SC_GATEWAY_TIMEOUT = HttpResponseExpectation.status(504);
    public static final HttpResponseExpectation SC_HTTP_VERSION_NOT_SUPPORTED = HttpResponseExpectation.status(505);
    public static final HttpResponseExpectation SC_VARIANT_ALSO_NEGOTIATES = HttpResponseExpectation.status(506);
    public static final HttpResponseExpectation SC_INSUFFICIENT_STORAGE = HttpResponseExpectation.status(507);
    public static final HttpResponseExpectation SC_NOT_EXTENDED = HttpResponseExpectation.status(510);
    public static final HttpResponseExpectation SC_NETWORK_AUTHENTICATION_REQUIRED = HttpResponseExpectation.status(511);
    public static final HttpResponseExpectation JSON = HttpResponseExpectation.contentType("application/json");

    public static HttpResponseExpectation status(int statusCode) {
        return HttpResponseExpectation.status(statusCode, statusCode + 1);
    }

    public static HttpResponseExpectation status(final int min, final int max) {
        return new HttpResponseExpectation(){

            @Override
            public boolean test(HttpResponseHead value) {
                int sc = value.statusCode();
                return sc >= min && sc < max;
            }

            public Exception describe(HttpResponseHead value) {
                int sc = value.statusCode();
                if (max - min == 1) {
                    return new VertxException("Response status code " + sc + " is not equal to " + min, true);
                }
                return new VertxException("Response status code " + sc + " is not between " + min + " and " + max, true);
            }
        };
    }

    public static HttpResponseExpectation contentType(String mimeType) {
        return HttpResponseExpectation.contentType(Collections.singletonList(mimeType));
    }

    public static HttpResponseExpectation contentType(String ... mimeTypes) {
        return HttpResponseExpectation.contentType(Arrays.asList(mimeTypes));
    }

    public static HttpResponseExpectation contentType(final List<String> mimeTypes) {
        return new HttpResponseExpectation(){

            @Override
            public boolean test(HttpResponseHead value) {
                String contentType = value.headers().get(HttpHeaders.CONTENT_TYPE);
                if (contentType == null) {
                    return false;
                }
                int paramIdx = contentType.indexOf(59);
                String mediaType = paramIdx != -1 ? contentType.substring(0, paramIdx) : contentType;
                for (String mimeType : mimeTypes) {
                    if (!mediaType.equalsIgnoreCase(mimeType)) continue;
                    return true;
                }
                return false;
            }

            public Exception describe(HttpResponseHead value) {
                String contentType = value.headers().get(HttpHeaders.CONTENT_TYPE);
                if (contentType == null) {
                    return new VertxException("Missing response content type", true);
                }
                StringBuilder sb = new StringBuilder("Expect content type ").append(contentType).append(" to be one of ");
                boolean first2 = true;
                for (String mimeType : mimeTypes) {
                    if (!first2) {
                        sb.append(", ");
                    }
                    first2 = false;
                    sb.append(mimeType);
                }
                return new VertxException(sb.toString(), true);
            }
        };
    }
}

