/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli;

import io.vertx.core.cli.Argument;
import io.vertx.core.cli.CLI;
import io.vertx.core.cli.Option;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class UsageMessageFormatter {
    public static final int DEFAULT_WIDTH = 80;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_DESC_PAD = 3;
    public static final String DEFAULT_USAGE_PREFIX = "Usage: ";
    public static final String DEFAULT_OPT_PREFIX = "-";
    public static final String DEFAULT_LONG_OPT_PREFIX = "--";
    public static final String DEFAULT_LONG_OPT_SEPARATOR = " ";
    public static final String DEFAULT_ARG_NAME = "arg";
    private int width = 80;
    private int leftPad = 1;
    private int descPad = 3;
    private String usagePrefix = "Usage: ";
    private String newLine = System.lineSeparator();
    private String defaultOptionPrefix = "-";
    private String defaultLongOptPrefix = "--";
    private String defaultArgName = "arg";
    private String longOptSeparator = " ";
    protected Comparator<Option> optionComparator = (opt1, opt2) -> opt1.getName().compareToIgnoreCase(opt2.getName());

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setLeftPadding(int padding) {
        this.leftPad = padding;
    }

    public int getLeftPadding() {
        return this.leftPad;
    }

    public void setDescPadding(int padding) {
        this.descPad = padding;
    }

    public int getDescPadding() {
        return this.descPad;
    }

    public void setUsagePrefix(String prefix) {
        this.usagePrefix = prefix;
    }

    public String getUsagePrefix() {
        return this.usagePrefix;
    }

    public void setNewLine(String newline) {
        this.newLine = newline;
    }

    public String getNewLine() {
        return this.newLine;
    }

    public void setOptionPrefix(String prefix) {
        this.defaultOptionPrefix = prefix;
    }

    public String getOptionPrefix() {
        return this.defaultOptionPrefix;
    }

    public void setLongOptionPrefix(String prefix) {
        this.defaultLongOptPrefix = prefix;
    }

    public String getLongOptionPrefix() {
        return this.defaultLongOptPrefix;
    }

    public void setLongOptionSeparator(String longOptSeparator) {
        this.longOptSeparator = longOptSeparator;
    }

    public String getLongOptionSeparator() {
        return this.longOptSeparator;
    }

    public void setArgName(String name) {
        this.defaultArgName = name;
    }

    public String getArgName() {
        return this.defaultArgName;
    }

    public Comparator<Option> getOptionComparator() {
        return this.optionComparator;
    }

    public void setOptionComparator(Comparator<Option> comparator) {
        this.optionComparator = comparator;
    }

    protected void appendOption(StringBuilder buff, Option option) {
        if (option.isHidden()) {
            return;
        }
        if (!option.isRequired()) {
            buff.append("[");
        }
        if (!UsageMessageFormatter.isNullOrEmpty(option.getShortName())) {
            buff.append(DEFAULT_OPT_PREFIX).append(option.getShortName());
        } else {
            buff.append(DEFAULT_LONG_OPT_PREFIX).append(option.getLongName());
        }
        if (!option.getChoices().isEmpty()) {
            buff.append(UsageMessageFormatter.isNullOrEmpty(option.getShortName()) ? this.getLongOptionSeparator() : DEFAULT_LONG_OPT_SEPARATOR);
            buff.append(option.getChoices().stream().collect(Collectors.joining(", ", "{", "}")));
        } else if (option.acceptValue() && (option.getArgName() == null || option.getArgName().length() != 0)) {
            buff.append(UsageMessageFormatter.isNullOrEmpty(option.getShortName()) ? this.getLongOptionSeparator() : DEFAULT_LONG_OPT_SEPARATOR);
            buff.append("<").append(option.getArgName() != null ? option.getArgName() : this.getArgName()).append(">");
        }
        if (!option.isRequired()) {
            buff.append("]");
        }
    }

    protected void appendArgument(StringBuilder buff, Argument argument, boolean required) {
        if (argument.isHidden()) {
            return;
        }
        if (!required) {
            buff.append("[");
        }
        buff.append(argument.getArgName());
        if (argument.isMultiValued()) {
            buff.append("...");
        }
        if (!required) {
            buff.append("]");
        }
    }

    public void usage(StringBuilder builder, CLI cli) {
        this.usage(builder, null, cli);
    }

    public void usage(StringBuilder builder, String prefix, CLI cli) {
        this.computeUsageLine(builder, prefix, cli);
        if (cli.getSummary() != null && cli.getSummary().trim().length() > 0) {
            this.buildWrapped(builder, "\n" + cli.getSummary());
        }
        if (cli.getDescription() != null && cli.getDescription().trim().length() > 0) {
            this.buildWrapped(builder, "\n" + cli.getDescription());
        }
        builder.append("\n");
        if (cli.getOptions().isEmpty() && cli.getArguments().isEmpty()) {
            return;
        }
        builder.append("Options and Arguments:\n");
        this.computeOptionsAndArguments(builder, cli.getOptions(), cli.getArguments());
    }

    public void computeUsage(StringBuilder buffer, String cmdLineSyntax) {
        int argPos = cmdLineSyntax.indexOf(32) + 1;
        this.buildWrapped(buffer, this.getUsagePrefix().length() + argPos, this.getUsagePrefix() + cmdLineSyntax);
    }

    public void computeUsageLine(StringBuilder buffer, String prefix, CLI cli) {
        StringBuilder buff;
        if (prefix == null) {
            buff = new StringBuilder(this.getUsagePrefix());
        } else {
            buff = new StringBuilder(this.getUsagePrefix()).append(prefix);
            if (!prefix.endsWith(DEFAULT_LONG_OPT_SEPARATOR)) {
                buff.append(DEFAULT_LONG_OPT_SEPARATOR);
            }
        }
        buff.append(cli.getName()).append(DEFAULT_LONG_OPT_SEPARATOR);
        if (this.getOptionComparator() != null) {
            Collections.sort(cli.getOptions(), this.getOptionComparator());
        }
        for (Option option : cli.getOptions()) {
            this.appendOption(buff, option);
            buff.append(DEFAULT_LONG_OPT_SEPARATOR);
        }
        for (Argument arg : cli.getArguments()) {
            this.appendArgument(buff, arg, arg.isRequired());
            buff.append(DEFAULT_LONG_OPT_SEPARATOR);
        }
        this.buildWrapped(buffer, buff.toString().indexOf(32) + 1, buff.toString());
    }

    public void computeOptionsAndArguments(StringBuilder buffer, List<Option> options, List<Argument> arguments) {
        this.renderOptionsAndArguments(buffer, options, arguments);
        buffer.append(this.newLine);
    }

    public void buildWrapped(StringBuilder buffer, String text) {
        this.buildWrapped(buffer, 0, text);
    }

    public void buildWrapped(StringBuilder buffer, int nextLineTabStop, String text) {
        this.renderWrappedTextBlock(buffer, this.width, nextLineTabStop, text);
        buffer.append(this.newLine);
    }

    protected StringBuilder renderCommands(StringBuilder sb, Collection<CLI> commands) {
        String lpad = UsageMessageFormatter.createPadding(this.leftPad);
        String dpad = UsageMessageFormatter.createPadding(this.descPad);
        int max = 0;
        ArrayList<StringBuilder> prefixList = new ArrayList<StringBuilder>();
        for (CLI command2 : commands) {
            if (command2.isHidden()) continue;
            StringBuilder buf = new StringBuilder();
            buf.append(lpad).append("   ").append(command2.getName());
            prefixList.add(buf);
            max = Math.max(buf.length(), max);
        }
        int x = 0;
        Iterator<CLI> it = commands.iterator();
        while (it.hasNext()) {
            StringBuilder buf;
            CLI command3 = it.next();
            if (command3.isHidden()) continue;
            if ((buf = new StringBuilder(((StringBuilder)prefixList.get(x++)).toString())).length() < max) {
                buf.append(UsageMessageFormatter.createPadding(max - buf.length()));
            }
            buf.append(dpad);
            int nextLineTabStop = max + this.descPad;
            buf.append(command3.getSummary());
            this.renderWrappedText(sb, this.width, nextLineTabStop, buf.toString());
            if (!it.hasNext()) continue;
            sb.append(this.getNewLine());
        }
        return sb;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    protected StringBuilder renderOptionsAndArguments(StringBuilder sb, List<Option> options, List<Argument> arguments) {
        int nextLineTabStop;
        StringBuilder buf;
        String lpad = UsageMessageFormatter.createPadding(this.leftPad);
        String dpad = UsageMessageFormatter.createPadding(this.descPad);
        int max = 0;
        ArrayList<StringBuilder> prefixList = new ArrayList<StringBuilder>();
        if (this.getOptionComparator() != null) {
            Collections.sort(options, this.getOptionComparator());
        }
        for (Option option : options) {
            buf = new StringBuilder();
            if (option.isHidden()) continue;
            if (UsageMessageFormatter.isNullOrEmpty(option.getShortName())) {
                buf.append(lpad).append("   ").append(this.getLongOptionPrefix()).append(option.getLongName());
            } else {
                buf.append(lpad).append(this.getOptionPrefix()).append(option.getShortName());
                if (!UsageMessageFormatter.isNullOrEmpty(option.getLongName())) {
                    buf.append(',').append(this.getLongOptionPrefix()).append(option.getLongName());
                }
            }
            if (!option.getChoices().isEmpty()) {
                buf.append(!UsageMessageFormatter.isNullOrEmpty(option.getLongName()) ? this.longOptSeparator : DEFAULT_LONG_OPT_SEPARATOR);
                buf.append(option.getChoices().stream().collect(Collectors.joining(", ", "{", "}")));
            } else if (option.acceptValue()) {
                String argName = option.getArgName();
                if (argName != null && argName.length() == 0) {
                    buf.append(' ');
                } else {
                    buf.append(!UsageMessageFormatter.isNullOrEmpty(option.getLongName()) ? this.longOptSeparator : DEFAULT_LONG_OPT_SEPARATOR);
                    buf.append("<").append(argName != null ? option.getArgName() : this.getArgName()).append(">");
                }
            }
            prefixList.add(buf);
            max = Math.max(buf.length(), max);
        }
        for (Argument argument : arguments) {
            buf = new StringBuilder();
            if (argument.isHidden()) continue;
            buf.append(lpad).append("<").append(argument.getArgName()).append(">");
            prefixList.add(buf);
            max = Math.max(buf.length(), max);
        }
        int x = 0;
        Iterator<Object> it = options.iterator();
        while (it.hasNext()) {
            StringBuilder optBuf;
            Option option = it.next();
            if (option.isHidden()) continue;
            if ((optBuf = new StringBuilder(((StringBuilder)prefixList.get(x++)).toString())).length() < max) {
                optBuf.append(UsageMessageFormatter.createPadding(max - optBuf.length()));
            }
            optBuf.append(dpad);
            nextLineTabStop = max + this.descPad;
            if (option.getDescription() != null) {
                optBuf.append(option.getDescription());
            }
            this.renderWrappedText(sb, this.width, nextLineTabStop, optBuf.toString());
            if (!it.hasNext()) continue;
            sb.append(this.getNewLine());
        }
        if (!options.isEmpty() && !arguments.isEmpty()) {
            sb.append(this.getNewLine());
        }
        it = arguments.iterator();
        while (it.hasNext()) {
            StringBuilder argBuf;
            Argument argument = (Argument)it.next();
            if (argument.isHidden()) continue;
            if ((argBuf = new StringBuilder(((StringBuilder)prefixList.get(x++)).toString())).length() < max) {
                argBuf.append(UsageMessageFormatter.createPadding(max - argBuf.length()));
            }
            argBuf.append(dpad);
            nextLineTabStop = max + this.descPad;
            if (argument.getDescription() != null) {
                argBuf.append(argument.getDescription());
            }
            this.renderWrappedText(sb, this.width, nextLineTabStop, argBuf.toString());
            if (!it.hasNext()) continue;
            sb.append(this.getNewLine());
        }
        return sb;
    }

    protected StringBuilder renderWrappedText(StringBuilder sb, int width, int nextLineTabStop, String text) {
        int pos = UsageMessageFormatter.findWrapPos(text, width, 0);
        if (pos == -1) {
            sb.append(UsageMessageFormatter.rtrim(text));
            return sb;
        }
        sb.append(UsageMessageFormatter.rtrim(text.substring(0, pos))).append(this.getNewLine());
        if (nextLineTabStop >= width) {
            nextLineTabStop = 1;
        }
        String padding = UsageMessageFormatter.createPadding(nextLineTabStop);
        while (true) {
            if ((pos = UsageMessageFormatter.findWrapPos(text = padding + text.substring(pos).trim(), width, 0)) == -1) {
                sb.append(text);
                return sb;
            }
            if (text.length() > width && pos == nextLineTabStop - 1) {
                pos = width;
            }
            sb.append(UsageMessageFormatter.rtrim(text.substring(0, pos))).append(this.getNewLine());
        }
    }

    public Appendable renderWrappedTextBlock(StringBuilder sb, int width, int nextLineTabStop, String text) {
        try (BufferedReader in = new BufferedReader(new StringReader(text));){
            String line;
            boolean firstLine = true;
            while ((line = in.readLine()) != null) {
                if (!firstLine) {
                    sb.append(this.getNewLine());
                } else {
                    firstLine = false;
                }
                this.renderWrappedText(sb, width, nextLineTabStop, line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb;
    }

    public static int findWrapPos(String text, int width, int startPos) {
        char c;
        int pos = text.indexOf(10, startPos);
        if (pos != -1 && pos <= width) {
            return pos + 1;
        }
        pos = text.indexOf(9, startPos);
        if (pos != -1 && pos <= width) {
            return pos + 1;
        }
        if (startPos + width >= text.length()) {
            return -1;
        }
        for (pos = startPos + width; pos >= startPos && (c = text.charAt(pos)) != ' ' && c != '\n' && c != '\r'; --pos) {
        }
        if (pos > startPos) {
            return pos;
        }
        pos = startPos + width;
        return pos == text.length() ? -1 : pos;
    }

    public static String createPadding(int len) {
        char[] padding = new char[len];
        Arrays.fill(padding, ' ');
        return new String(padding);
    }

    public static String rtrim(String s) {
        int pos;
        if (s == null || s.length() == 0) {
            return s;
        }
        for (pos = s.length(); pos > 0 && Character.isWhitespace(s.charAt(pos - 1)); --pos) {
        }
        return s.substring(0, pos);
    }
}

