/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.decoder;

import io.micrometer.core.instrument.Counter;
import io.sip3.commons.micrometer.Metrics;
import io.sip3.commons.util.IpUtil;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.decoder.HepDecoder;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.domain.Packet;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/sip3/salto/ce/decoder/HepDecoder;", "Lio/vertx/core/AbstractVerticle;", "()V", "logger", "Lmu/KLogger;", "packetsDecoded", "Lio/micrometer/core/instrument/Counter;", "rtcpEnabled", "", "decodeHep2", "", "sender", "Lio/sip3/salto/ce/domain/Address;", "buffer", "Lio/vertx/core/buffer/Buffer;", "decodeHep3", "start", "Companion", "sip3-salto-ce"})
public final class HepDecoder
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    private boolean rtcpEnabled;
    @NotNull
    private final Counter packetsDecoded = Metrics.INSTANCE.counter("packets_decoded", MapsKt.mapOf(TuplesKt.to("proto", "hep")));
    public static final int HEP3_HEADER_LENGTH = 6;
    public static final byte HEP3_TYPE_SIP = 1;
    public static final byte HEP3_TYPE_RTCP = 5;

    @Override
    public void start() {
        Object object = this.config().getJsonObject("hep");
        if (object != null && (object = ((JsonObject)object).getJsonObject("rtcp")) != null && (object = ((JsonObject)object).getBoolean("enabled")) != null) {
            boolean it = (Boolean)object;
            boolean bl = false;
            this.rtcpEnabled = it;
        }
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getHep2(), arg_0 -> HepDecoder.start$lambda$1(this, arg_0));
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getHep3(), arg_0 -> HepDecoder.start$lambda$2(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final void decodeHep2(@NotNull Address sender, @NotNull Buffer buffer) {
        void $this$decodeHep2_u24lambda_u245_u24lambda_u244;
        Address $this$decodeHep2_u24lambda_u245_u24lambda_u243;
        Address address;
        Packet packet;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        int packetLength = buffer.length();
        if (packetLength < 31) {
            this.logger.warn("HEP2 payload is to short: " + packetLength);
            return;
        }
        int srcPort = buffer.getUnsignedShort(4);
        int dstPort = buffer.getUnsignedShort(6);
        byte[] byArray = buffer.getBytes(8, 12);
        Intrinsics.checkNotNullExpressionValue(byArray, "buffer.getBytes(8, 12)");
        byte[] srcAddr = byArray;
        byte[] byArray2 = buffer.getBytes(12, 16);
        Intrinsics.checkNotNullExpressionValue(byArray2, "buffer.getBytes(12, 16)");
        byte[] dstAddr = byArray2;
        long seconds = buffer.getUnsignedIntLE(16);
        long uSeconds = buffer.getUnsignedIntLE(20);
        byte[] byArray3 = buffer.getBytes(28, packetLength);
        Intrinsics.checkNotNullExpressionValue(byArray3, "buffer.getBytes(28, packetLength)");
        byte[] payload = byArray3;
        Packet $this$decodeHep2_u24lambda_u245 = packet = new Packet();
        boolean bl = false;
        $this$decodeHep2_u24lambda_u245.setCreatedAt(seconds * (long)1000 + uSeconds / (long)1000);
        $this$decodeHep2_u24lambda_u245.setNanos((int)(uSeconds % (long)1000));
        Address address2 = address = new Address();
        Packet packet2 = $this$decodeHep2_u24lambda_u245;
        boolean bl2 = false;
        $this$decodeHep2_u24lambda_u245_u24lambda_u243.setAddr(IpUtil.INSTANCE.convertToString(srcAddr));
        $this$decodeHep2_u24lambda_u245_u24lambda_u243.setPort(srcPort);
        packet2.setSrcAddr(address);
        $this$decodeHep2_u24lambda_u245_u24lambda_u243 = address = new Address();
        packet2 = $this$decodeHep2_u24lambda_u245;
        boolean bl3 = false;
        $this$decodeHep2_u24lambda_u245_u24lambda_u244.setAddr(IpUtil.INSTANCE.convertToString(dstAddr));
        $this$decodeHep2_u24lambda_u245_u24lambda_u244.setPort(dstPort);
        packet2.setDstAddr(address);
        $this$decodeHep2_u24lambda_u245.setProtocolCode((byte)3);
        $this$decodeHep2_u24lambda_u245.setPayload(payload);
        Packet packet3 = packet;
        this.packetsDecoded.increment();
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getRouter(), new Pair<Address, List<Packet>>(sender, CollectionsKt.listOf(packet3)), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void decodeHep3(@NotNull Address sender, @NotNull Buffer buffer) {
        void $this$decodeHep3_u24lambda_u248_u24lambda_u247;
        Address $this$decodeHep3_u24lambda_u248_u24lambda_u246;
        Packet packet;
        int length;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Long seconds = null;
        Long uSeconds = null;
        byte[] srcAddr = null;
        byte[] dstAddr = null;
        Integer srcPort = null;
        Integer dstPort = null;
        Byte protocolType = null;
        byte[] payload = null;
        block10: for (int offset = 6; offset < buffer.length(); offset += length) {
            short type = buffer.getShort(offset += 2);
            length = buffer.getShort(offset += 2) - 6;
            offset += 2;
            switch (type) {
                case 3: {
                    srcAddr = buffer.getBytes(offset + length - 4, offset + length);
                    continue block10;
                }
                case 4: {
                    dstAddr = buffer.getBytes(offset + length - 4, offset + length);
                    continue block10;
                }
                case 7: {
                    srcPort = buffer.getUnsignedShort(offset);
                    continue block10;
                }
                case 8: {
                    dstPort = buffer.getUnsignedShort(offset);
                    continue block10;
                }
                case 9: {
                    seconds = buffer.getUnsignedInt(offset);
                    continue block10;
                }
                case 10: {
                    uSeconds = buffer.getUnsignedInt(offset);
                    continue block10;
                }
                case 11: {
                    protocolType = buffer.getByte(offset);
                    continue block10;
                }
                case 15: {
                    payload = buffer.getBytes(offset, offset + length);
                }
            }
        }
        if (!this.rtcpEnabled) {
            Byte by = protocolType;
            boolean bl = by != null ? by == 5 : false;
            if (bl) {
                return;
            }
        }
        Packet $this$decodeHep3_u24lambda_u248 = packet = new Packet();
        boolean bl = false;
        Long l = seconds;
        Intrinsics.checkNotNull(l);
        long l2 = ((Number)l).longValue() * (long)1000;
        Long l3 = uSeconds;
        Intrinsics.checkNotNull(l3);
        $this$decodeHep3_u24lambda_u248.setCreatedAt(l2 + ((Number)l3).longValue() / (long)1000);
        $this$decodeHep3_u24lambda_u248.setNanos((int)(((Number)uSeconds).longValue() % (long)1000));
        Object object = new Address();
        Address address = object;
        Packet packet2 = $this$decodeHep3_u24lambda_u248;
        boolean bl2 = false;
        Intrinsics.checkNotNull(srcAddr);
        $this$decodeHep3_u24lambda_u248_u24lambda_u246.setAddr(IpUtil.INSTANCE.convertToString(srcAddr));
        Integer n = srcPort;
        Intrinsics.checkNotNull(n);
        $this$decodeHep3_u24lambda_u248_u24lambda_u246.setPort(((Number)n).intValue());
        packet2.setSrcAddr((Address)object);
        object = new Address();
        $this$decodeHep3_u24lambda_u248_u24lambda_u246 = object;
        packet2 = $this$decodeHep3_u24lambda_u248;
        boolean bl3 = false;
        Intrinsics.checkNotNull(dstAddr);
        $this$decodeHep3_u24lambda_u248_u24lambda_u247.setAddr(IpUtil.INSTANCE.convertToString(dstAddr));
        Integer n2 = dstPort;
        Intrinsics.checkNotNull(n2);
        $this$decodeHep3_u24lambda_u248_u24lambda_u247.setPort(((Number)n2).intValue());
        packet2.setDstAddr((Address)object);
        $this$decodeHep3_u24lambda_u248.setSource("hep3");
        Object object2 = object = protocolType;
        boolean bl4 = object2 != null ? (Byte)object2 == 1 : false;
        if (bl4) {
            $this$decodeHep3_u24lambda_u248.setProtocolCode((byte)3);
        } else {
            Object object3 = object;
            boolean bl5 = object3 != null ? (Byte)object3 == 5 : false;
            if (bl5) {
                $this$decodeHep3_u24lambda_u248.setProtocolCode((byte)1);
            } else {
                throw new NotImplementedError("Unknown HEPv3 protocol type: " + protocolType);
            }
        }
        Intrinsics.checkNotNull(payload);
        $this$decodeHep3_u24lambda_u248.setPayload(payload);
        Packet packet3 = packet;
        this.packetsDecoded.increment();
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getRouter(), new Pair<Address, List<Packet>>(sender, CollectionsKt.listOf(packet3)), null, 4, null);
    }

    private static final void start$lambda$1(HepDecoder this$0, Message event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            Pair pair = (Pair)event.body();
            Address sender = (Address)pair.component1();
            Buffer buffer = (Buffer)pair.component2();
            this$0.decodeHep2(sender, buffer);
        }
        catch (Exception e) {
            this$0.logger.error("HepDecoder 'decodeHep2()' failed.", e);
        }
    }

    private static final void start$lambda$2(HepDecoder this$0, Message event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            Pair pair = (Pair)event.body();
            Address sender = (Address)pair.component1();
            Buffer buffer = (Buffer)pair.component2();
            this$0.decodeHep3(sender, buffer);
        }
        catch (Exception e) {
            this$0.logger.error("HepDecoder 'decodeHep3()' failed.", e);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/sip3/salto/ce/decoder/HepDecoder$Companion;", "", "()V", "HEP3_HEADER_LENGTH", "", "HEP3_TYPE_RTCP", "", "HEP3_TYPE_SIP", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

