/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.commons.domain.payload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.sip3.commons.domain.payload.Decodable;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.util.ByteBufUtilKt;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lio/sip3/commons/domain/payload/RecordingPayload;", "Lio/sip3/commons/domain/payload/Encodable;", "Lio/sip3/commons/domain/payload/Decodable;", "()V", "callId", "", "getCallId", "()Ljava/lang/String;", "setCallId", "(Ljava/lang/String;)V", "mode", "", "getMode", "()B", "setMode", "(B)V", "payload", "", "getPayload", "()[B", "setPayload", "([B)V", "type", "getType", "setType", "decode", "", "buffer", "Lio/netty/buffer/ByteBuf;", "encode", "Companion", "sip3-commons"})
public final class RecordingPayload
implements Encodable,
Decodable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private byte type = (byte)-1;
    private byte mode = (byte)-1;
    public String callId;
    public byte[] payload;
    public static final int FIXED_PAYLOAD_LENGTH = 14;
    public static final int TAG_TYPE = 1;
    public static final int TAG_MODE = 2;
    public static final int TAG_CALL_ID = 3;
    public static final int TAG_PAYLOAD = 4;

    public final byte getType() {
        return this.type;
    }

    public final void setType(byte by) {
        this.type = by;
    }

    public final byte getMode() {
        return this.mode;
    }

    public final void setMode(byte by) {
        this.mode = by;
    }

    @NotNull
    public final String getCallId() {
        String string = this.callId;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("callId");
        return null;
    }

    public final void setCallId(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.callId = string;
    }

    @NotNull
    public final byte[] getPayload() {
        if (this.payload != null) {
            return this.payload;
        }
        Intrinsics.throwUninitializedPropertyAccessException("payload");
        return null;
    }

    public final void setPayload(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "<set-?>");
        this.payload = byArray;
    }

    @Override
    @NotNull
    public ByteBuf encode() {
        ByteBuf byteBuf;
        int bufferSize = 14 + this.getCallId().length() + this.getPayload().length;
        ByteBuf $this$encode_u24lambda_u240 = byteBuf = Unpooled.buffer(bufferSize);
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue($this$encode_u24lambda_u240, "encode$lambda$0");
        ByteBufUtilKt.writeTlv($this$encode_u24lambda_u240, 1, this.type);
        ByteBufUtilKt.writeTlv($this$encode_u24lambda_u240, 2, this.mode);
        ByteBufUtilKt.writeTlv($this$encode_u24lambda_u240, 3, this.getCallId());
        ByteBufUtilKt.writeTlv($this$encode_u24lambda_u240, 4, this.getPayload());
        ByteBuf byteBuf2 = byteBuf;
        Intrinsics.checkNotNullExpressionValue(byteBuf2, "buffer(bufferSize).apply\u2026YLOAD, payload)\n        }");
        return byteBuf2;
    }

    @Override
    public void decode(@NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        while (buffer.readableBytes() > 0) {
            byte tag = buffer.readByte();
            int length = buffer.readShort() - 3;
            switch (tag) {
                case 1: {
                    this.type = buffer.readByte();
                    break;
                }
                case 2: {
                    this.mode = buffer.readByte();
                    break;
                }
                case 3: {
                    this.setCallId(((Object)buffer.readCharSequence(length, Charset.defaultCharset())).toString());
                    break;
                }
                case 4: {
                    this.setPayload(new byte[length]);
                    buffer.readBytes(this.getPayload());
                }
            }
        }
    }

    @Override
    public void decode(@NotNull byte[] bytes) {
        Decodable.DefaultImpls.decode(this, bytes);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/sip3/commons/domain/payload/RecordingPayload$Companion;", "", "()V", "FIXED_PAYLOAD_LENGTH", "", "TAG_CALL_ID", "TAG_MODE", "TAG_PAYLOAD", "TAG_TYPE", "sip3-commons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

