/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.shaded.reactor.core.publisher.FluxSink;
import io.micrometer.statsd.StatsdLineBuilder;
import java.util.concurrent.atomic.DoubleAdder;

public class StatsdCounter
extends AbstractMeter
implements Counter {
    private final StatsdLineBuilder lineBuilder;
    private final FluxSink<String> sink;
    private DoubleAdder count = new DoubleAdder();
    private volatile boolean shutdown;

    StatsdCounter(Meter.Id id, StatsdLineBuilder lineBuilder, FluxSink<String> sink2) {
        super(id);
        this.lineBuilder = lineBuilder;
        this.sink = sink2;
    }

    @Override
    public void increment(double amount) {
        if (!this.shutdown && amount > 0.0) {
            this.count.add(amount);
            this.sink.next(this.lineBuilder.count((long)amount));
        }
    }

    @Override
    public double count() {
        return this.count.doubleValue();
    }

    void shutdown() {
        this.shutdown = true;
    }
}

