/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.util.context;

import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.context.Context0;
import io.micrometer.shaded.reactor.util.context.Context1;
import io.micrometer.shaded.reactor.util.context.Context2;
import io.micrometer.shaded.reactor.util.context.Context3;
import io.micrometer.shaded.reactor.util.context.Context4;
import io.micrometer.shaded.reactor.util.context.Context5;
import io.micrometer.shaded.reactor.util.context.ContextN;
import io.micrometer.shaded.reactor.util.context.ContextView;
import io.micrometer.shaded.reactor.util.context.CoreContext;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public interface Context
extends ContextView {
    public static Context empty() {
        return Context0.INSTANCE;
    }

    public static Context of(Object key, Object value) {
        return new Context1(key, value);
    }

    public static Context of(Object key1, Object value1, Object key2, Object value2) {
        return new Context2(key1, value1, key2, value2);
    }

    public static Context of(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3) {
        return new Context3(key1, value1, key2, value2, key3, value3);
    }

    public static Context of(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3, Object key4, Object value4) {
        return new Context4(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public static Context of(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3, Object key4, Object value4, Object key5, Object value5) {
        return new Context5(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
    }

    public static Context of(Map<?, ?> map2) {
        int size = Objects.requireNonNull(map2, "map").size();
        if (size == 0) {
            return Context.empty();
        }
        if (size <= 5) {
            Map.Entry[] entries2 = map2.entrySet().toArray(new Map.Entry[size]);
            switch (size) {
                case 1: {
                    return new Context1(entries2[0].getKey(), entries2[0].getValue());
                }
                case 2: {
                    return new Context2(entries2[0].getKey(), entries2[0].getValue(), entries2[1].getKey(), entries2[1].getValue());
                }
                case 3: {
                    return new Context3(entries2[0].getKey(), entries2[0].getValue(), entries2[1].getKey(), entries2[1].getValue(), entries2[2].getKey(), entries2[2].getValue());
                }
                case 4: {
                    return new Context4(entries2[0].getKey(), entries2[0].getValue(), entries2[1].getKey(), entries2[1].getValue(), entries2[2].getKey(), entries2[2].getValue(), entries2[3].getKey(), entries2[3].getValue());
                }
                case 5: {
                    return new Context5(entries2[0].getKey(), entries2[0].getValue(), entries2[1].getKey(), entries2[1].getValue(), entries2[2].getKey(), entries2[2].getValue(), entries2[3].getKey(), entries2[3].getValue(), entries2[4].getKey(), entries2[4].getValue());
                }
            }
        }
        map2.forEach((? super K key, ? super V value) -> {
            Objects.requireNonNull(key, "null key found");
            if (value == null) {
                throw new NullPointerException("null value for key " + key);
            }
        });
        Map<Object, Object> generifiedMap = map2;
        return new ContextN(generifiedMap);
    }

    public static Context of(ContextView contextView) {
        Objects.requireNonNull(contextView, "contextView");
        if (contextView instanceof Context) {
            return (Context)contextView;
        }
        return Context.empty().putAll(contextView);
    }

    default public ContextView readOnly() {
        return this;
    }

    public Context put(Object var1, Object var2);

    default public Context putNonNull(Object key, @Nullable Object valueOrNull) {
        if (valueOrNull != null) {
            return this.put(key, valueOrNull);
        }
        return this;
    }

    public Context delete(Object var1);

    default public Context putAll(ContextView other) {
        if (other.isEmpty()) {
            return this;
        }
        if (other instanceof CoreContext) {
            CoreContext coreContext = (CoreContext)other;
            return coreContext.putAllInto(this);
        }
        ContextN newContext = new ContextN(this.size() + other.size());
        ((Stream)this.stream().sequential()).forEach(newContext);
        ((Stream)other.stream().sequential()).forEach(newContext);
        if (newContext.size() <= 5) {
            return Context.of(newContext);
        }
        return newContext;
    }

    default public Context putAllMap(Map<?, ?> from) {
        if (from.isEmpty()) {
            return this;
        }
        ContextN combined = new ContextN(this.size() + from.size());
        this.forEach(combined);
        from.forEach(combined);
        if (combined.size() <= 5) {
            return Context.of(combined);
        }
        return combined;
    }

    @Deprecated
    default public Context putAll(Context context) {
        return this.putAll(context.readOnly());
    }
}

