/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.transport;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import io.micrometer.shaded.io.netty.buffer.ByteBufAllocator;
import io.micrometer.shaded.io.netty.buffer.ByteBufAllocatorMetric;
import io.micrometer.shaded.io.netty.buffer.PooledByteBufAllocator;
import io.micrometer.shaded.io.netty.buffer.PooledByteBufAllocatorMetric;
import io.micrometer.shaded.reactor.netty.Metrics;
import io.micrometer.shaded.reactor.netty.internal.util.MapUtils;
import io.micrometer.shaded.reactor.netty.transport.ByteBufAllocatorMeters;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class ByteBufAllocatorMetrics {
    static final ByteBufAllocatorMetrics INSTANCE = new ByteBufAllocatorMetrics();
    final ConcurrentMap<String, ByteBufAllocatorMetric> cache = new ConcurrentHashMap<String, ByteBufAllocatorMetric>();

    private ByteBufAllocatorMetrics() {
    }

    void registerMetrics(String allocType, ByteBufAllocatorMetric metrics, ByteBufAllocator alloc) {
        MapUtils.computeIfAbsent(this.cache, metrics.hashCode() + "", key -> {
            Tags tags = Tags.of(ByteBufAllocatorMeters.ByteBufAllocatorMetersTags.ID.asString(), key, ByteBufAllocatorMeters.ByteBufAllocatorMetersTags.TYPE.asString(), allocType);
            Gauge.builder(ByteBufAllocatorMeters.USED_HEAP_MEMORY.getName(), metrics, ByteBufAllocatorMetric::usedHeapMemory).tags(tags).register(Metrics.REGISTRY);
            Gauge.builder(ByteBufAllocatorMeters.USED_DIRECT_MEMORY.getName(), metrics, ByteBufAllocatorMetric::usedDirectMemory).tags(tags).register(Metrics.REGISTRY);
            if (metrics instanceof PooledByteBufAllocatorMetric) {
                PooledByteBufAllocatorMetric pooledMetrics = (PooledByteBufAllocatorMetric)metrics;
                PooledByteBufAllocator pooledAlloc = (PooledByteBufAllocator)alloc;
                Gauge.builder(ByteBufAllocatorMeters.HEAP_ARENAS.getName(), pooledMetrics, PooledByteBufAllocatorMetric::numHeapArenas).tags(tags).register(Metrics.REGISTRY);
                Gauge.builder(ByteBufAllocatorMeters.DIRECT_ARENAS.getName(), pooledMetrics, PooledByteBufAllocatorMetric::numDirectArenas).tags(tags).register(Metrics.REGISTRY);
                Gauge.builder(ByteBufAllocatorMeters.THREAD_LOCAL_CACHES.getName(), pooledMetrics, PooledByteBufAllocatorMetric::numThreadLocalCaches).tags(tags).register(Metrics.REGISTRY);
                Gauge.builder(ByteBufAllocatorMeters.SMALL_CACHE_SIZE.getName(), pooledMetrics, PooledByteBufAllocatorMetric::smallCacheSize).tags(tags).register(Metrics.REGISTRY);
                Gauge.builder(ByteBufAllocatorMeters.NORMAL_CACHE_SIZE.getName(), pooledMetrics, PooledByteBufAllocatorMetric::normalCacheSize).tags(tags).register(Metrics.REGISTRY);
                Gauge.builder(ByteBufAllocatorMeters.CHUNK_SIZE.getName(), pooledMetrics, PooledByteBufAllocatorMetric::chunkSize).tags(tags).register(Metrics.REGISTRY);
                Gauge.builder(ByteBufAllocatorMeters.ACTIVE_HEAP_MEMORY.getName(), pooledAlloc, PooledByteBufAllocator::pinnedHeapMemory).tags(tags).register(Metrics.REGISTRY);
                Gauge.builder(ByteBufAllocatorMeters.ACTIVE_DIRECT_MEMORY.getName(), pooledAlloc, PooledByteBufAllocator::pinnedDirectMemory).tags(tags).register(Metrics.REGISTRY);
            }
            return metrics;
        });
    }
}

