/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.decorators;

import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.Disposables;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.SignalType;
import io.micrometer.shaded.reactor.core.publisher.Sinks;
import io.micrometer.shaded.reactor.core.scheduler.Scheduler;
import io.micrometer.shaded.reactor.core.scheduler.Schedulers;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.PoolShutdownException;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.PooledRef;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.PooledRefMetadata;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class GracefulShutdownInstrumentedPool<T>
implements InstrumentedPool<T> {
    private static final Logger LOGGER = Loggers.getLogger(GracefulShutdownInstrumentedPool.class);
    final AtomicLong acquireTracker;
    final AtomicInteger isGracefulShutdown;
    final Sinks.Empty<Void> gracefulNotifier;
    final InstrumentedPool<T> originalPool;
    final Scheduler timeoutScheduler;
    Disposable timeout;

    GracefulShutdownInstrumentedPool(InstrumentedPool<T> originalPool) {
        Scheduler forTimeout;
        this.originalPool = Objects.requireNonNull(originalPool, "originalPool");
        this.acquireTracker = new AtomicLong();
        this.isGracefulShutdown = new AtomicInteger();
        this.gracefulNotifier = Sinks.empty();
        this.timeout = Disposables.single();
        try {
            forTimeout = originalPool.config().evictInBackgroundScheduler();
            if (forTimeout == Schedulers.immediate()) {
                forTimeout = Schedulers.parallel();
            }
        }
        catch (UnsupportedOperationException uoe) {
            forTimeout = Schedulers.parallel();
        }
        this.timeoutScheduler = forTimeout;
    }

    public InstrumentedPool<T> getOriginalPool() {
        return this.originalPool;
    }

    @Override
    public Mono<PooledRef<T>> acquire() {
        if (this.isGracefulShutdown.get() > 0) {
            return Mono.error(new PoolShutdownException("The pool is being gracefully shut down and won't accept new acquire calls"));
        }
        return Mono.defer(() -> {
            this.acquireTracker.incrementAndGet();
            return this.originalPool.acquire().doFinally(st -> {
                if (st == SignalType.ON_ERROR || st == SignalType.CANCEL) {
                    this.acquireTracker.decrementAndGet();
                }
            }).map(x$0 -> new GracefulRef(x$0));
        });
    }

    @Override
    public Mono<PooledRef<T>> acquire(Duration timeout2) {
        if (this.isGracefulShutdown.get() > 0) {
            return Mono.error(new PoolShutdownException("The pool is being gracefully shut down and won't accept new acquire calls"));
        }
        return Mono.defer(() -> {
            this.acquireTracker.incrementAndGet();
            return this.originalPool.acquire(timeout2).doFinally(st -> {
                if (st == SignalType.ON_ERROR || st == SignalType.CANCEL) {
                    this.acquireTracker.decrementAndGet();
                }
            }).map(x$0 -> new GracefulRef(x$0));
        });
    }

    public Mono<Void> disposeGracefully(Duration gracefulTimeout) {
        if (this.isGracefulShutdown.compareAndSet(0, 1)) {
            if (this.acquireTracker.get() == 0L && this.isGracefulShutdown.compareAndSet(1, 2)) {
                this.originalPool.disposeLater().doFinally(st -> this.gracefulNotifier.tryEmitEmpty()).subscribe(v -> {}, shutdownError -> LOGGER.warn("Error during the actual shutdown on idle pool", (Throwable)shutdownError));
                return this.gracefulNotifier.asMono();
            }
            this.timeout = this.timeoutScheduler.schedule(() -> {
                if (this.isGracefulShutdown.compareAndSet(1, 2)) {
                    this.originalPool.disposeLater().doFinally(st -> {
                        TimeoutException timeoutError = new TimeoutException("Pool has forcefully shut down after graceful timeout of " + gracefulTimeout);
                        Sinks.EmitResult emitResult = this.gracefulNotifier.tryEmitError(timeoutError);
                    }).subscribe(v -> {}, timedOutError -> LOGGER.warn("Error during the graceful shutdown upon graceful timeout", (Throwable)timedOutError));
                }
            }, gracefulTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        return this.gracefulNotifier.asMono();
    }

    public boolean isGracefullyShuttingDown() {
        return this.isGracefulShutdown.get() > 0;
    }

    public boolean isInGracePeriod() {
        return this.isGracefulShutdown.get() == 1;
    }

    private Mono<Void> tryGracefulDone() {
        if (this.isGracefulShutdown.compareAndSet(1, 2)) {
            this.timeout.dispose();
            return this.originalPool.disposeLater().doFinally(st -> this.gracefulNotifier.emitEmpty(Sinks.EmitFailureHandler.FAIL_FAST));
        }
        return Mono.empty();
    }

    @Override
    public InstrumentedPool.PoolMetrics metrics() {
        return this.originalPool.metrics();
    }

    @Override
    public PoolConfig<T> config() {
        return this.originalPool.config();
    }

    @Override
    public Mono<Integer> warmup() {
        return this.originalPool.warmup();
    }

    @Override
    public Mono<Void> disposeLater() {
        return this.originalPool.disposeLater();
    }

    @Override
    public boolean isDisposed() {
        return this.originalPool.isDisposed();
    }

    final class GracefulRef
    extends AtomicBoolean
    implements PooledRef<T> {
        final PooledRef<T> originalRef;

        public GracefulRef(PooledRef<T> originalRef) {
            this.originalRef = originalRef;
        }

        @Override
        public T poolable() {
            return this.originalRef.poolable();
        }

        @Override
        public PooledRefMetadata metadata() {
            return this.originalRef.metadata();
        }

        @Override
        public Mono<Void> invalidate() {
            if (this.get()) {
                return Mono.empty();
            }
            return Mono.defer(() -> {
                if (this.compareAndSet(false, true)) {
                    long remaining = GracefulShutdownInstrumentedPool.this.acquireTracker.decrementAndGet();
                    if (remaining > 0L) {
                        return this.originalRef.invalidate();
                    }
                    if (remaining == 0L) {
                        return this.originalRef.invalidate().then(Mono.defer(() -> GracefulShutdownInstrumentedPool.this.tryGracefulDone()));
                    }
                }
                return Mono.empty();
            });
        }

        @Override
        public Mono<Void> release() {
            if (this.get()) {
                return Mono.empty();
            }
            return Mono.defer(() -> {
                if (this.compareAndSet(false, true)) {
                    long remaining = GracefulShutdownInstrumentedPool.this.acquireTracker.decrementAndGet();
                    if (remaining > 0L) {
                        return this.originalRef.release();
                    }
                    if (remaining == 0L) {
                        return this.originalRef.release().then(Mono.defer(() -> GracefulShutdownInstrumentedPool.this.tryGracefulDone()));
                    }
                }
                return Mono.empty();
            });
        }
    }
}

