/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.FluxFilter;
import io.micrometer.shaded.reactor.core.publisher.ParallelFlux;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.util.function.Predicate;

final class ParallelFilter<T>
extends ParallelFlux<T>
implements Scannable {
    final ParallelFlux<T> source;
    final Predicate<? super T> predicate;

    ParallelFilter(ParallelFlux<T> source2, Predicate<? super T> predicate) {
        this.source = source2;
        this.predicate = predicate;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        CoreSubscriber[] parents = new CoreSubscriber[n];
        boolean conditional = subscribers[0] instanceof Fuseable.ConditionalSubscriber;
        for (int i2 = 0; i2 < n; ++i2) {
            parents[i2] = conditional ? new FluxFilter.FilterConditionalSubscriber<T>((Fuseable.ConditionalSubscriber)subscribers[i2], this.predicate) : new FluxFilter.FilterSubscriber<T>(subscribers[i2], this.predicate);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }
}

