/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarantlr4.v4.gui;

import groovyjarjarantlr4.v4.gui.Trees;
import groovyjarjarantlr4.v4.runtime.CharStream;
import groovyjarjarantlr4.v4.runtime.CharStreams;
import groovyjarjarantlr4.v4.runtime.CommonToken;
import groovyjarjarantlr4.v4.runtime.CommonTokenStream;
import groovyjarjarantlr4.v4.runtime.DiagnosticErrorListener;
import groovyjarjarantlr4.v4.runtime.Lexer;
import groovyjarjarantlr4.v4.runtime.Parser;
import groovyjarjarantlr4.v4.runtime.ParserRuleContext;
import groovyjarjarantlr4.v4.runtime.Token;
import groovyjarjarantlr4.v4.runtime.TokenStream;
import groovyjarjarantlr4.v4.runtime.atn.ParserATNSimulator;
import groovyjarjarantlr4.v4.runtime.atn.PredictionMode;
import groovyjarjarantlr4.v4.runtime.tree.Tree;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintException;

public class TestRig {
    public static final String LEXER_START_RULE_NAME = "tokens";
    protected String grammarName;
    protected String startRuleName;
    protected final List<String> inputFiles = new ArrayList<String>();
    protected boolean printTree = false;
    protected boolean gui = false;
    protected String psFile = null;
    protected boolean showTokens = false;
    protected boolean trace = false;
    protected boolean diagnostics = false;
    protected String encoding = null;
    protected boolean SLL = false;

    public TestRig(String[] args2) throws Exception {
        if (args2.length < 2) {
            System.err.println("java org.antlr.v4.gui.TestRig GrammarName startRuleName\n  [-tokens] [-tree] [-gui] [-ps file.ps] [-encoding encodingname]\n  [-trace] [-diagnostics] [-SLL]\n  [input-filename(s)]");
            System.err.println("Use startRuleName='tokens' if GrammarName is a lexer grammar.");
            System.err.println("Omitting input-filename makes rig read from stdin.");
            return;
        }
        int i2 = 0;
        this.grammarName = args2[i2];
        this.startRuleName = args2[++i2];
        ++i2;
        while (i2 < args2.length) {
            String arg = args2[i2];
            ++i2;
            if (arg.charAt(0) != '-') {
                this.inputFiles.add(arg);
                continue;
            }
            if (arg.equals("-tree")) {
                this.printTree = true;
            }
            if (arg.equals("-gui")) {
                this.gui = true;
            }
            if (arg.equals("-tokens")) {
                this.showTokens = true;
                continue;
            }
            if (arg.equals("-trace")) {
                this.trace = true;
                continue;
            }
            if (arg.equals("-SLL")) {
                this.SLL = true;
                continue;
            }
            if (arg.equals("-diagnostics")) {
                this.diagnostics = true;
                continue;
            }
            if (arg.equals("-encoding")) {
                if (i2 >= args2.length) {
                    System.err.println("missing encoding on -encoding");
                    return;
                }
                this.encoding = args2[i2];
                ++i2;
                continue;
            }
            if (!arg.equals("-ps")) continue;
            if (i2 >= args2.length) {
                System.err.println("missing filename on -ps");
                return;
            }
            this.psFile = args2[i2];
            ++i2;
        }
    }

    public static void main(String[] args2) throws Exception {
        TestRig testRig = new TestRig(args2);
        if (args2.length >= 2) {
            testRig.process();
        }
    }

    public void process() throws Exception {
        Charset charset;
        String lexerName = this.grammarName + "Lexer";
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<Lexer> lexerClass = null;
        try {
            lexerClass = cl.loadClass(lexerName).asSubclass(Lexer.class);
        }
        catch (ClassNotFoundException cnfe) {
            lexerName = this.grammarName;
            try {
                lexerClass = cl.loadClass(lexerName).asSubclass(Lexer.class);
            }
            catch (ClassNotFoundException cnfe2) {
                System.err.println("Can't load " + lexerName + " as lexer or parser");
                return;
            }
        }
        Constructor<Lexer> lexerCtor = lexerClass.getConstructor(CharStream.class);
        Lexer lexer = lexerCtor.newInstance(new Object[]{null});
        Class<Parser> parserClass = null;
        Parser parser2 = null;
        if (!this.startRuleName.equals(LEXER_START_RULE_NAME)) {
            String parserName = this.grammarName + "Parser";
            parserClass = cl.loadClass(parserName).asSubclass(Parser.class);
            Constructor<Parser> parserCtor = parserClass.getConstructor(TokenStream.class);
            parser2 = parserCtor.newInstance(new Object[]{null});
        }
        Charset charset2 = charset = this.encoding == null ? Charset.defaultCharset() : Charset.forName(this.encoding);
        if (this.inputFiles.isEmpty()) {
            CharStream charStream = CharStreams.fromStream(System.in, charset);
            this.process(lexer, parserClass, parser2, charStream);
            return;
        }
        for (String inputFile : this.inputFiles) {
            CharStream charStream = CharStreams.fromFile(new File(inputFile), charset);
            if (this.inputFiles.size() > 1) {
                System.err.println(inputFile);
            }
            this.process(lexer, parserClass, parser2, charStream);
        }
    }

    protected void process(Lexer lexer, Class<? extends Parser> parserClass, Parser parser2, CharStream input) throws IOException, IllegalAccessException, InvocationTargetException, PrintException {
        lexer.setInputStream(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        tokens.fill();
        if (this.showTokens) {
            for (Token tok : tokens.getTokens()) {
                if (tok instanceof CommonToken) {
                    System.out.println(((CommonToken)tok).toString(lexer));
                    continue;
                }
                System.out.println(tok.toString());
            }
        }
        if (this.startRuleName.equals(LEXER_START_RULE_NAME)) {
            return;
        }
        if (this.diagnostics) {
            parser2.addErrorListener(new DiagnosticErrorListener());
            ((ParserATNSimulator)parser2.getInterpreter()).setPredictionMode(PredictionMode.LL_EXACT_AMBIG_DETECTION);
        }
        if (this.printTree || this.gui || this.psFile != null) {
            parser2.setBuildParseTree(true);
        }
        if (this.SLL) {
            ((ParserATNSimulator)parser2.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        }
        parser2.setInputStream(tokens);
        parser2.setTrace(this.trace);
        try {
            Method startRule = parserClass.getMethod(this.startRuleName, new Class[0]);
            ParserRuleContext tree = (ParserRuleContext)startRule.invoke((Object)parser2, (Object[])null);
            if (this.printTree) {
                System.out.println(tree.toStringTree(parser2));
            }
            if (this.gui) {
                Trees.inspect((Tree)tree, parser2);
            }
            if (this.psFile != null) {
                Trees.save((Tree)tree, parser2, this.psFile);
            }
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("No method for rule " + this.startRuleName + " or it has arguments");
        }
    }
}

